/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CSRSparseMatrixToSparseTensor", inputsClass=Inputs.class)
public final class CSRSparseMatrixToSparseTensor<T extends TType>
extends RawOp {
    public static final String OP_NAME = "CSRSparseMatrixToSparseTensor";
    private Output<TInt64> indices;
    private Output<T> values;
    private Output<TInt64> denseShape;

    public CSRSparseMatrixToSparseTensor(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.values = operation.output(outputIdx++);
        this.denseShape = operation.output(outputIdx++);
    }

    public static <T extends TType> CSRSparseMatrixToSparseTensor<T> create(Scope scope, Operand<? extends TType> sparseMatrix, Class<T> type) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(sparseMatrix.asOutput());
        opBuilder.setAttr("type", Operands.toDataType(type));
        return new CSRSparseMatrixToSparseTensor<T>(opBuilder.build());
    }

    public Output<TInt64> indices() {
        return this.indices;
    }

    public Output<T> values() {
        return this.values;
    }

    public Output<TInt64> denseShape() {
        return this.denseShape;
    }

    @OpInputsMetadata(outputsClass=CSRSparseMatrixToSparseTensor.class)
    public static class Inputs
    extends RawOpInputs<CSRSparseMatrixToSparseTensor<?>> {
        public final Operand<? extends TType> sparseMatrix;
        public final DataType type;

        public Inputs(GraphOperation op) {
            super(new CSRSparseMatrixToSparseTensor(op), op, Arrays.asList("type"));
            int inputIndex = 0;
            this.sparseMatrix = op.input(inputIndex++);
            this.type = op.attributes().getAttrType("type");
        }
    }
}

