/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="AnonymousMultiDeviceIterator", inputsClass=Inputs.class)
public final class AnonymousMultiDeviceIterator
extends RawOp {
    public static final String OP_NAME = "AnonymousMultiDeviceIterator";
    private Output<? extends TType> handle;
    private Output<? extends TType> deleter;

    public AnonymousMultiDeviceIterator(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
        this.deleter = operation.output(outputIdx++);
    }

    public static AnonymousMultiDeviceIterator create(Scope scope, List<String> devices, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        String[] devicesArray = new String[devices.size()];
        for (int i = 0; i < devicesArray.length; ++i) {
            devicesArray[i] = devices.get(i);
        }
        opBuilder.setAttr("devices", devicesArray);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new AnonymousMultiDeviceIterator(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    public Output<? extends TType> deleter() {
        return this.deleter;
    }

    @OpInputsMetadata(outputsClass=AnonymousMultiDeviceIterator.class)
    public static class Inputs
    extends RawOpInputs<AnonymousMultiDeviceIterator> {
        public final String[] devices;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new AnonymousMultiDeviceIterator(op), op, Arrays.asList("devices", "output_types", "output_shapes"));
            boolean inputIndex = false;
            this.devices = op.attributes().getAttrStringList("devices");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

