/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.ndarray.index.Index;
import org.tensorflow.ndarray.index.Indices;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.StridedSlice;
import org.tensorflow.op.core.StridedSliceAssign;
import org.tensorflow.types.family.TType;

public abstract class StridedSliceHelper {
    static StridedSliceArgs mergeIndexes(Index[] indices) {
        int[] begin = new int[indices.length];
        int[] end = new int[indices.length];
        int[] strides = new int[indices.length];
        long beginMask = 0L;
        long endMask = 0L;
        long ellipsisMask = 0L;
        long newAxisMask = 0L;
        long shrinkAxisMask = 0L;
        for (int i = 0; i < indices.length; ++i) {
            Index idx = indices[i];
            if (idx == null) {
                idx = Indices.all();
            }
            if (!idx.isStridedSlicingCompliant()) {
                throw new UnsupportedOperationException("Index " + idx + " is not supported for Tensors");
            }
            begin[i] = (int)idx.begin();
            if ((long)begin[i] != idx.begin()) {
                throw new IllegalArgumentException("Can't convert long begin value to int for index " + idx + ": Out of bounds");
            }
            end[i] = (int)idx.end();
            if ((long)end[i] != idx.end()) {
                throw new IllegalArgumentException("Can't convert long end value to int for index " + idx + ": Out of bounds");
            }
            strides[i] = (int)idx.stride();
            if ((long)strides[i] != idx.stride()) {
                throw new IllegalArgumentException("Can't convert long stride value to int for index " + idx + ": Out of bounds");
            }
            if (idx.beginMask()) {
                beginMask |= 1L << i;
            }
            if (idx.endMask()) {
                endMask |= 1L << i;
            }
            if (idx.isEllipsis()) {
                if (ellipsisMask != 0L) {
                    throw new IllegalArgumentException("Can not have two ellipsis in a slice");
                }
                ellipsisMask |= 1L << i;
            }
            if (idx.isNewAxis()) {
                newAxisMask |= 1L << i;
            }
            if (!idx.isPoint()) continue;
            shrinkAxisMask |= 1L << i;
        }
        return new StridedSliceArgs(begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
    }

    public static <T extends TType> StridedSlice<T> stridedSlice(Scope scope, Operand<T> input, Index ... indices) {
        StridedSliceArgs args = StridedSliceHelper.mergeIndexes(indices);
        return StridedSlice.create(scope, input, Constant.vectorOf(scope, args.begin), Constant.vectorOf(scope, args.end), Constant.vectorOf(scope, args.strides), StridedSlice.beginMask(args.beginMask), StridedSlice.endMask(args.endMask), StridedSlice.ellipsisMask(args.ellipsisMask), StridedSlice.newAxisMask(args.newAxisMask), StridedSlice.shrinkAxisMask(args.shrinkAxisMask));
    }

    public static <T extends TType> StridedSliceAssign<T> stridedSliceAssign(Scope scope, Operand<T> ref, Operand<T> value, Index ... indices) {
        StridedSliceArgs args = StridedSliceHelper.mergeIndexes(indices);
        return StridedSliceAssign.create(scope, ref, Constant.vectorOf(scope, args.begin), Constant.vectorOf(scope, args.end), Constant.vectorOf(scope, args.strides), value, StridedSliceAssign.beginMask(args.beginMask), StridedSliceAssign.endMask(args.endMask), StridedSliceAssign.ellipsisMask(args.ellipsisMask), StridedSliceAssign.newAxisMask(args.newAxisMask), StridedSliceAssign.shrinkAxisMask(args.shrinkAxisMask));
    }

    static class StridedSliceArgs {
        final int[] begin;
        final int[] end;
        final int[] strides;
        final long beginMask;
        final long endMask;
        final long ellipsisMask;
        final long newAxisMask;
        final long shrinkAxisMask;

        private StridedSliceArgs(int[] begin, int[] end, int[] strides, long beginMask, long endMask, long ellipsisMask, long newAxisMask, long shrinkAxisMask) {
            this.begin = begin;
            this.end = end;
            this.strides = strides;
            this.beginMask = beginMask;
            this.endMask = endMask;
            this.ellipsisMask = ellipsisMask;
            this.newAxisMask = newAxisMask;
            this.shrinkAxisMask = shrinkAxisMask;
        }
    }
}

