/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="Bucketize", inputsClass=Inputs.class)
public final class Bucketize
extends RawOp
implements Operand<TInt32> {
    public static final String OP_NAME = "Bucketize";
    private Output<TInt32> output;

    public Bucketize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static Bucketize create(Scope scope, Operand<? extends TNumber> input, List<Float> boundaries) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        float[] boundariesArray = new float[boundaries.size()];
        for (int i = 0; i < boundariesArray.length; ++i) {
            boundariesArray[i] = boundaries.get(i).floatValue();
        }
        opBuilder.setAttr("boundaries", boundariesArray);
        return new Bucketize(opBuilder.build());
    }

    public Output<TInt32> output() {
        return this.output;
    }

    @Override
    public Output<TInt32> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Bucketize.class)
    public static class Inputs
    extends RawOpInputs<Bucketize> {
        public final Operand<? extends TNumber> input;
        public final DataType T;
        public final float[] boundaries;

        public Inputs(GraphOperation op) {
            super(new Bucketize(op), op, Arrays.asList("T", "boundaries"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.boundaries = op.attributes().getAttrFloatList("boundaries");
        }
    }
}

