/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.BaseGradientAdapter;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.internal.c_api.NativeOperation;
import org.tensorflow.internal.c_api.NativeOutputVector;
import org.tensorflow.internal.c_api.NativeStatus;
import org.tensorflow.internal.c_api.TF_Scope;
import org.tensorflow.op.GradientScope;
import org.tensorflow.op.Ops;
import org.tensorflow.op.RawCustomGradient;

final class RawGradientAdapter
extends BaseGradientAdapter {
    private final RawCustomGradient gradient;

    RawGradientAdapter(RawCustomGradient gradient) {
        this.gradient = gradient;
    }

    @Override
    public NativeStatus call(TF_Scope scope, NativeOperation op, NativeOutputVector grad_inputs, NativeOutputVector grad_outputs) {
        try (PointerScope pointerScope = new PointerScope(new Class[0]);){
            Graph g = Graph.findGraphForPointer(scope.graph());
            if (g == null) {
                throw new IllegalStateException("No graph found for native gradient scope.");
            }
            GraphOperation operation = BaseGradientAdapter.getGraphOp(g, op.node());
            GradientScope nativeScope = new GradientScope(scope, g, null).withSubScope(operation.name());
            Ops tf = new Ops(nativeScope);
            List<Output<?>> gradInputs = BaseGradientAdapter.fromNativeOutputs(g, grad_inputs);
            BaseGradientAdapter.useDangerousLockedBuilders(g, true);
            List<Operand<?>> gradOutputs = this.gradient.call(tf, operation, gradInputs);
            BaseGradientAdapter.useDangerousLockedBuilders(g, false);
            BaseGradientAdapter.putToNativeOutputs(gradOutputs, grad_outputs);
        }
        return NativeStatus.OK();
    }
}

