/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaDotV2", inputsClass=Inputs.class)
public final class Dot<V extends TType>
extends RawOp
implements Operand<V> {
    public static final String OP_NAME = "XlaDotV2";
    private Output<V> output;

    public Dot(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <V extends TType> Dot<V> create(Scope scope, Operand<? extends TType> lhs, Operand<? extends TType> rhs, String dimensionNumbers, String precisionConfig, Class<V> preferredElementType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Dot");
        opBuilder.addInput(lhs.asOutput());
        opBuilder.addInput(rhs.asOutput());
        opBuilder.setAttr("dimension_numbers", dimensionNumbers);
        opBuilder.setAttr("precision_config", precisionConfig);
        opBuilder.setAttr("preferred_element_type", Operands.toDataType(preferredElementType));
        return new Dot<V>(opBuilder.build());
    }

    public Output<V> output() {
        return this.output;
    }

    @Override
    public Output<V> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Dot.class)
    public static class Inputs
    extends RawOpInputs<Dot<?>> {
        public final Operand<? extends TType> lhs;
        public final Operand<? extends TType> rhs;
        public final DataType LhsT;
        public final DataType RhsT;
        public final String dimensionNumbers;
        public final String precisionConfig;
        public final DataType preferredElementType;

        public Inputs(GraphOperation op) {
            super(new Dot(op), op, Arrays.asList("LhsT", "RhsT", "dimension_numbers", "precision_config", "preferred_element_type"));
            int inputIndex = 0;
            this.lhs = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.LhsT = op.attributes().getAttrType("LhsT");
            this.RhsT = op.attributes().getAttrType("RhsT");
            this.dimensionNumbers = op.attributes().getAttrString("dimension_numbers");
            this.precisionConfig = op.attributes().getAttrString("precision_config");
            this.preferredElementType = op.attributes().getAttrType("preferred_element_type");
        }
    }
}

