/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt64;

@OpMetadata(opType="SparseReshape", inputsClass=Inputs.class)
public final class SparseReshape
extends RawOp {
    public static final String OP_NAME = "SparseReshape";
    private Output<TInt64> outputIndices;
    private Output<TInt64> outputShape;

    public SparseReshape(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }

    public static SparseReshape create(Scope scope, Operand<TInt64> inputIndices, Operand<TInt64> inputShape, Operand<TInt64> newShape) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputIndices.asOutput());
        opBuilder.addInput(inputShape.asOutput());
        opBuilder.addInput(newShape.asOutput());
        return new SparseReshape(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<TInt64> outputShape() {
        return this.outputShape;
    }

    @OpInputsMetadata(outputsClass=SparseReshape.class)
    public static class Inputs
    extends RawOpInputs<SparseReshape> {
        public final Operand<TInt64> inputIndices;
        public final Operand<TInt64> inputShape;
        public final Operand<TInt64> newShape;

        public Inputs(GraphOperation op) {
            super(new SparseReshape(op), op, Arrays.asList(new String[0]));
            int inputIndex = 0;
            this.inputIndices = op.input(inputIndex++);
            this.inputShape = op.input(inputIndex++);
            this.newShape = op.input(inputIndex++);
        }
    }
}

