/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseConditionalAccumulator", inputsClass=Inputs.class)
public final class SparseConditionalAccumulator
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "SparseConditionalAccumulator";
    private Output<TString> handle;

    public SparseConditionalAccumulator(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseConditionalAccumulator create(Scope scope, Class<T> dtype, Shape shape, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        opBuilder.setAttr("shape", shape);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.reductionType == null) continue;
                opBuilder.setAttr("reduction_type", opts.reductionType);
            }
        }
        return new SparseConditionalAccumulator(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options reductionType(String reductionType) {
        return new Options().reductionType(reductionType);
    }

    public Output<TString> handle() {
        return this.handle;
    }

    @Override
    public Output<TString> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=SparseConditionalAccumulator.class)
    public static class Inputs
    extends RawOpInputs<SparseConditionalAccumulator> {
        public final DataType dtype;
        public final Shape shape;
        public final String container;
        public final String sharedName;
        public final String reductionType;

        public Inputs(GraphOperation op) {
            super(new SparseConditionalAccumulator(op), op, Arrays.asList("dtype", "shape", "container", "shared_name", "reduction_type"));
            boolean inputIndex = false;
            this.dtype = op.attributes().getAttrType("dtype");
            this.shape = op.attributes().getAttrShape("shape");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.reductionType = op.attributes().getAttrString("reduction_type");
        }
    }

    public static class Options {
        private String container;
        private String sharedName;
        private String reductionType;

        private Options() {
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options reductionType(String reductionType) {
            this.reductionType = reductionType;
            return this;
        }
    }
}

