/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="SampleDistortedBoundingBoxV2", inputsClass=Inputs.class)
public final class SampleDistortedBoundingBox<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "SampleDistortedBoundingBoxV2";
    private Output<T> begin;
    private Output<T> sizeOutput;
    private Output<TFloat32> bboxes;

    public SampleDistortedBoundingBox(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.begin = operation.output(outputIdx++);
        this.sizeOutput = operation.output(outputIdx++);
        this.bboxes = operation.output(outputIdx++);
    }

    public static <T extends TNumber> SampleDistortedBoundingBox<T> create(Scope scope, Operand<T> imageSize, Operand<TFloat32> boundingBoxes, Operand<TFloat32> minObjectCovered, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SampleDistortedBoundingBox");
        opBuilder.addInput(imageSize.asOutput());
        opBuilder.addInput(boundingBoxes.asOutput());
        opBuilder.addInput(minObjectCovered.asOutput());
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.aspectRatioRange != null) {
                    float[] aspectRatioRangeArray = new float[opts.aspectRatioRange.size()];
                    for (i = 0; i < aspectRatioRangeArray.length; ++i) {
                        aspectRatioRangeArray[i] = ((Float)opts.aspectRatioRange.get(i)).floatValue();
                    }
                    opBuilder.setAttr("aspect_ratio_range", aspectRatioRangeArray);
                }
                if (opts.areaRange != null) {
                    float[] areaRangeArray = new float[opts.areaRange.size()];
                    for (i = 0; i < areaRangeArray.length; ++i) {
                        areaRangeArray[i] = ((Float)opts.areaRange.get(i)).floatValue();
                    }
                    opBuilder.setAttr("area_range", areaRangeArray);
                }
                if (opts.maxAttempts != null) {
                    opBuilder.setAttr("max_attempts", opts.maxAttempts);
                }
                if (opts.useImageIfNoBoundingBoxes == null) continue;
                opBuilder.setAttr("use_image_if_no_bounding_boxes", opts.useImageIfNoBoundingBoxes);
            }
        }
        return new SampleDistortedBoundingBox<T>(opBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options aspectRatioRange(List<Float> aspectRatioRange) {
        return new Options().aspectRatioRange(aspectRatioRange);
    }

    public static Options aspectRatioRange(Float ... aspectRatioRange) {
        return new Options().aspectRatioRange(aspectRatioRange);
    }

    public static Options areaRange(List<Float> areaRange) {
        return new Options().areaRange(areaRange);
    }

    public static Options areaRange(Float ... areaRange) {
        return new Options().areaRange(areaRange);
    }

    public static Options maxAttempts(Long maxAttempts) {
        return new Options().maxAttempts(maxAttempts);
    }

    public static Options useImageIfNoBoundingBoxes(Boolean useImageIfNoBoundingBoxes) {
        return new Options().useImageIfNoBoundingBoxes(useImageIfNoBoundingBoxes);
    }

    public Output<T> begin() {
        return this.begin;
    }

    public Output<T> sizeOutput() {
        return this.sizeOutput;
    }

    public Output<TFloat32> bboxes() {
        return this.bboxes;
    }

    @OpInputsMetadata(outputsClass=SampleDistortedBoundingBox.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<SampleDistortedBoundingBox<T>> {
        public final Operand<T> imageSize;
        public final Operand<TFloat32> boundingBoxes;
        public final Operand<TFloat32> minObjectCovered;
        public final DataType T;
        public final long seed;
        public final long seed2;
        public final float[] aspectRatioRange;
        public final float[] areaRange;
        public final long maxAttempts;
        public final boolean useImageIfNoBoundingBoxes;

        public Inputs(GraphOperation op) {
            super(new SampleDistortedBoundingBox(op), op, Arrays.asList("T", "seed", "seed2", "aspect_ratio_range", "area_range", "max_attempts", "use_image_if_no_bounding_boxes"));
            int inputIndex = 0;
            this.imageSize = op.input(inputIndex++);
            this.boundingBoxes = op.input(inputIndex++);
            this.minObjectCovered = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
            this.aspectRatioRange = op.attributes().getAttrFloatList("aspect_ratio_range");
            this.areaRange = op.attributes().getAttrFloatList("area_range");
            this.maxAttempts = op.attributes().getAttrInt("max_attempts");
            this.useImageIfNoBoundingBoxes = op.attributes().getAttrBool("use_image_if_no_bounding_boxes");
        }
    }

    public static class Options {
        private Long seed;
        private Long seed2;
        private List<Float> aspectRatioRange;
        private List<Float> areaRange;
        private Long maxAttempts;
        private Boolean useImageIfNoBoundingBoxes;

        private Options() {
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options aspectRatioRange(List<Float> aspectRatioRange) {
            this.aspectRatioRange = aspectRatioRange;
            return this;
        }

        public Options aspectRatioRange(Float ... aspectRatioRange) {
            this.aspectRatioRange = Arrays.asList(aspectRatioRange);
            return this;
        }

        public Options areaRange(List<Float> areaRange) {
            this.areaRange = areaRange;
            return this;
        }

        public Options areaRange(Float ... areaRange) {
            this.areaRange = Arrays.asList(areaRange);
            return this;
        }

        public Options maxAttempts(Long maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Options useImageIfNoBoundingBoxes(Boolean useImageIfNoBoundingBoxes) {
            this.useImageIfNoBoundingBoxes = useImageIfNoBoundingBoxes;
            return this;
        }
    }
}

