/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.sparse.AddManySparseToTensorsMap;
import org.tensorflow.op.sparse.AddSparseToTensorsMap;
import org.tensorflow.op.sparse.DenseToDenseSetOperation;
import org.tensorflow.op.sparse.DenseToSparseSetOperation;
import org.tensorflow.op.sparse.DeserializeSparse;
import org.tensorflow.op.sparse.SparseAccumulatorApplyGradient;
import org.tensorflow.op.sparse.SparseAccumulatorTakeGradient;
import org.tensorflow.op.sparse.SparseAdd;
import org.tensorflow.op.sparse.SparseAddGrad;
import org.tensorflow.op.sparse.SparseBincount;
import org.tensorflow.op.sparse.SparseConcat;
import org.tensorflow.op.sparse.SparseConditionalAccumulator;
import org.tensorflow.op.sparse.SparseCross;
import org.tensorflow.op.sparse.SparseCrossHashed;
import org.tensorflow.op.sparse.SparseDenseCwiseAdd;
import org.tensorflow.op.sparse.SparseDenseCwiseDiv;
import org.tensorflow.op.sparse.SparseDenseCwiseMul;
import org.tensorflow.op.sparse.SparseFillEmptyRows;
import org.tensorflow.op.sparse.SparseFillEmptyRowsGrad;
import org.tensorflow.op.sparse.SparseMatMul;
import org.tensorflow.op.sparse.SparseReduceMax;
import org.tensorflow.op.sparse.SparseReduceMaxSparse;
import org.tensorflow.op.sparse.SparseReduceSum;
import org.tensorflow.op.sparse.SparseReduceSumSparse;
import org.tensorflow.op.sparse.SparseReorder;
import org.tensorflow.op.sparse.SparseReshape;
import org.tensorflow.op.sparse.SparseSegmentMean;
import org.tensorflow.op.sparse.SparseSegmentMeanGrad;
import org.tensorflow.op.sparse.SparseSegmentMeanWithNumSegments;
import org.tensorflow.op.sparse.SparseSegmentSqrtN;
import org.tensorflow.op.sparse.SparseSegmentSqrtNGrad;
import org.tensorflow.op.sparse.SparseSegmentSqrtNWithNumSegments;
import org.tensorflow.op.sparse.SparseSegmentSum;
import org.tensorflow.op.sparse.SparseSegmentSumGrad;
import org.tensorflow.op.sparse.SparseSegmentSumWithNumSegments;
import org.tensorflow.op.sparse.SparseSlice;
import org.tensorflow.op.sparse.SparseSliceGrad;
import org.tensorflow.op.sparse.SparseSoftmax;
import org.tensorflow.op.sparse.SparseSparseMaximum;
import org.tensorflow.op.sparse.SparseSparseMinimum;
import org.tensorflow.op.sparse.SparseSplit;
import org.tensorflow.op.sparse.SparseTensorDenseAdd;
import org.tensorflow.op.sparse.SparseTensorDenseMatMul;
import org.tensorflow.op.sparse.SparseToDense;
import org.tensorflow.op.sparse.SparseToSparseSetOperation;
import org.tensorflow.op.sparse.TakeManySparseFromTensorsMap;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class SparseOps {
    private final Scope scope;
    private final Ops ops;

    SparseOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public AddManySparseToTensorsMap addManySparseToTensorsMap(Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape, AddManySparseToTensorsMap.Options ... options) {
        return AddManySparseToTensorsMap.create(this.scope, sparseIndices, sparseValues, sparseShape, options);
    }

    public AddSparseToTensorsMap addSparseToTensorsMap(Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape, AddSparseToTensorsMap.Options ... options) {
        return AddSparseToTensorsMap.create(this.scope, sparseIndices, sparseValues, sparseShape, options);
    }

    public <T extends TType> DenseToDenseSetOperation<T> denseToDenseSetOperation(Operand<T> set1, Operand<T> set2, String setOperation, DenseToDenseSetOperation.Options ... options) {
        return DenseToDenseSetOperation.create(this.scope, set1, set2, setOperation, options);
    }

    public <T extends TType> DenseToSparseSetOperation<T> denseToSparseSetOperation(Operand<T> set1, Operand<TInt64> set2Indices, Operand<T> set2Values, Operand<TInt64> set2Shape, String setOperation, DenseToSparseSetOperation.Options ... options) {
        return DenseToSparseSetOperation.create(this.scope, set1, set2Indices, set2Values, set2Shape, setOperation, options);
    }

    public <U extends TType> DeserializeSparse<U> deserializeSparse(Operand<? extends TType> serializedSparse, Class<U> dtype) {
        return DeserializeSparse.create(this.scope, serializedSparse, dtype);
    }

    public SparseAccumulatorApplyGradient sparseAccumulatorApplyGradient(Operand<TString> handle, Operand<TInt64> localStep, Operand<TInt64> gradientIndices, Operand<? extends TType> gradientValues, Operand<TInt64> gradientShape, Boolean hasKnownShape) {
        return SparseAccumulatorApplyGradient.create(this.scope, handle, localStep, gradientIndices, gradientValues, gradientShape, hasKnownShape);
    }

    public <T extends TType> SparseAccumulatorTakeGradient<T> sparseAccumulatorTakeGradient(Operand<TString> handle, Operand<TInt32> numRequired, Class<T> dtype) {
        return SparseAccumulatorTakeGradient.create(this.scope, handle, numRequired, dtype);
    }

    public <T extends TType> SparseAdd<T> sparseAdd(Operand<TInt64> aIndices, Operand<T> aValues, Operand<TInt64> aShape, Operand<TInt64> bIndices, Operand<T> bValues, Operand<TInt64> bShape, Operand<? extends TNumber> thresh) {
        return SparseAdd.create(this.scope, aIndices, aValues, aShape, bIndices, bValues, bShape, thresh);
    }

    public <T extends TType> SparseAddGrad<T> sparseAddGrad(Operand<T> backpropValGrad, Operand<TInt64> aIndices, Operand<TInt64> bIndices, Operand<TInt64> sumIndices) {
        return SparseAddGrad.create(this.scope, backpropValGrad, aIndices, bIndices, sumIndices);
    }

    public <U extends TNumber, T extends TNumber> SparseBincount<U> sparseBincount(Operand<TInt64> indices, Operand<T> values, Operand<TInt64> denseShape, Operand<T> sizeOutput, Operand<U> weights, SparseBincount.Options ... options) {
        return SparseBincount.create(this.scope, indices, values, denseShape, sizeOutput, weights, options);
    }

    public <T extends TType> SparseConcat<T> sparseConcat(Iterable<Operand<TInt64>> indices, Iterable<Operand<T>> values, Iterable<Operand<TInt64>> shapes, Long concatDim) {
        return SparseConcat.create(this.scope, indices, values, shapes, concatDim);
    }

    public <T extends TType> SparseConditionalAccumulator sparseConditionalAccumulator(Class<T> dtype, Shape shape, SparseConditionalAccumulator.Options ... options) {
        return SparseConditionalAccumulator.create(this.scope, dtype, shape, options);
    }

    public SparseCross sparseCross(Iterable<Operand<TInt64>> indices, Iterable<Operand<?>> values, Iterable<Operand<TInt64>> shapes, Iterable<Operand<?>> denseInputs, Operand<TString> sep) {
        return SparseCross.create(this.scope, indices, values, shapes, denseInputs, sep);
    }

    public SparseCrossHashed sparseCrossHashed(Iterable<Operand<TInt64>> indices, Iterable<Operand<?>> values, Iterable<Operand<TInt64>> shapes, Iterable<Operand<?>> denseInputs, Operand<TInt64> numBuckets, Operand<TBool> strongHash, Operand<TInt64> salt) {
        return SparseCrossHashed.create(this.scope, indices, values, shapes, denseInputs, numBuckets, strongHash, salt);
    }

    public <T extends TType> SparseDenseCwiseAdd<T> sparseDenseCwiseAdd(Operand<TInt64> spIndices, Operand<T> spValues, Operand<TInt64> spShape, Operand<T> dense) {
        return SparseDenseCwiseAdd.create(this.scope, spIndices, spValues, spShape, dense);
    }

    public <T extends TType> SparseDenseCwiseDiv<T> sparseDenseCwiseDiv(Operand<TInt64> spIndices, Operand<T> spValues, Operand<TInt64> spShape, Operand<T> dense) {
        return SparseDenseCwiseDiv.create(this.scope, spIndices, spValues, spShape, dense);
    }

    public <T extends TType> SparseDenseCwiseMul<T> sparseDenseCwiseMul(Operand<TInt64> spIndices, Operand<T> spValues, Operand<TInt64> spShape, Operand<T> dense) {
        return SparseDenseCwiseMul.create(this.scope, spIndices, spValues, spShape, dense);
    }

    public <T extends TType> SparseFillEmptyRows<T> sparseFillEmptyRows(Operand<TInt64> indices, Operand<T> values, Operand<TInt64> denseShape, Operand<T> defaultValue) {
        return SparseFillEmptyRows.create(this.scope, indices, values, denseShape, defaultValue);
    }

    public <T extends TType> SparseFillEmptyRowsGrad<T> sparseFillEmptyRowsGrad(Operand<TInt64> reverseIndexMap, Operand<T> gradValues) {
        return SparseFillEmptyRowsGrad.create(this.scope, reverseIndexMap, gradValues);
    }

    public SparseMatMul sparseMatMul(Operand<? extends TNumber> a, Operand<? extends TNumber> b, SparseMatMul.Options ... options) {
        return SparseMatMul.create(this.scope, a, b, options);
    }

    public <T extends TNumber> SparseReduceMax<T> sparseReduceMax(Operand<TInt64> inputIndices, Operand<T> inputValues, Operand<TInt64> inputShape, Operand<TInt32> reductionAxes, SparseReduceMax.Options ... options) {
        return SparseReduceMax.create(this.scope, inputIndices, inputValues, inputShape, reductionAxes, options);
    }

    public <T extends TNumber> SparseReduceMaxSparse<T> sparseReduceMaxSparse(Operand<TInt64> inputIndices, Operand<T> inputValues, Operand<TInt64> inputShape, Operand<TInt32> reductionAxes, SparseReduceMaxSparse.Options ... options) {
        return SparseReduceMaxSparse.create(this.scope, inputIndices, inputValues, inputShape, reductionAxes, options);
    }

    public <T extends TType> SparseReduceSum<T> sparseReduceSum(Operand<TInt64> inputIndices, Operand<T> inputValues, Operand<TInt64> inputShape, Operand<TInt32> reductionAxes, SparseReduceSum.Options ... options) {
        return SparseReduceSum.create(this.scope, inputIndices, inputValues, inputShape, reductionAxes, options);
    }

    public <T extends TType> SparseReduceSumSparse<T> sparseReduceSumSparse(Operand<TInt64> inputIndices, Operand<T> inputValues, Operand<TInt64> inputShape, Operand<TInt32> reductionAxes, SparseReduceSumSparse.Options ... options) {
        return SparseReduceSumSparse.create(this.scope, inputIndices, inputValues, inputShape, reductionAxes, options);
    }

    public <T extends TType> SparseReorder<T> sparseReorder(Operand<TInt64> inputIndices, Operand<T> inputValues, Operand<TInt64> inputShape) {
        return SparseReorder.create(this.scope, inputIndices, inputValues, inputShape);
    }

    public SparseReshape sparseReshape(Operand<TInt64> inputIndices, Operand<TInt64> inputShape, Operand<TInt64> newShape) {
        return SparseReshape.create(this.scope, inputIndices, inputShape, newShape);
    }

    public <T extends TNumber> SparseSegmentMean<T> sparseSegmentMean(Operand<T> data, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds) {
        return SparseSegmentMean.create(this.scope, data, indices, segmentIds);
    }

    public <T extends TNumber> SparseSegmentMeanGrad<T> sparseSegmentMeanGrad(Operand<T> grad, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds, Operand<TInt32> outputDim0) {
        return SparseSegmentMeanGrad.create(this.scope, grad, indices, segmentIds, outputDim0);
    }

    public <T extends TNumber> SparseSegmentMeanWithNumSegments<T> sparseSegmentMeanWithNumSegments(Operand<T> data, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds, Operand<? extends TNumber> numSegments) {
        return SparseSegmentMeanWithNumSegments.create(this.scope, data, indices, segmentIds, numSegments);
    }

    public <T extends TNumber> SparseSegmentSqrtN<T> sparseSegmentSqrtN(Operand<T> data, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds) {
        return SparseSegmentSqrtN.create(this.scope, data, indices, segmentIds);
    }

    public <T extends TNumber> SparseSegmentSqrtNGrad<T> sparseSegmentSqrtNGrad(Operand<T> grad, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds, Operand<TInt32> outputDim0) {
        return SparseSegmentSqrtNGrad.create(this.scope, grad, indices, segmentIds, outputDim0);
    }

    public <T extends TNumber> SparseSegmentSqrtNWithNumSegments<T> sparseSegmentSqrtNWithNumSegments(Operand<T> data, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds, Operand<? extends TNumber> numSegments) {
        return SparseSegmentSqrtNWithNumSegments.create(this.scope, data, indices, segmentIds, numSegments);
    }

    public <T extends TNumber> SparseSegmentSum<T> sparseSegmentSum(Operand<T> data, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds) {
        return SparseSegmentSum.create(this.scope, data, indices, segmentIds);
    }

    public <T extends TNumber> SparseSegmentSumGrad<T> sparseSegmentSumGrad(Operand<T> grad, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds, Operand<TInt32> outputDim0) {
        return SparseSegmentSumGrad.create(this.scope, grad, indices, segmentIds, outputDim0);
    }

    public <T extends TNumber> SparseSegmentSumWithNumSegments<T> sparseSegmentSumWithNumSegments(Operand<T> data, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds, Operand<? extends TNumber> numSegments) {
        return SparseSegmentSumWithNumSegments.create(this.scope, data, indices, segmentIds, numSegments);
    }

    public <T extends TType> SparseSlice<T> sparseSlice(Operand<TInt64> indices, Operand<T> values, Operand<TInt64> shape, Operand<TInt64> start, Operand<TInt64> sizeOutput) {
        return SparseSlice.create(this.scope, indices, values, shape, start, sizeOutput);
    }

    public <T extends TType> SparseSliceGrad<T> sparseSliceGrad(Operand<T> backpropValGrad, Operand<TInt64> inputIndices, Operand<TInt64> inputStart, Operand<TInt64> outputIndices) {
        return SparseSliceGrad.create(this.scope, backpropValGrad, inputIndices, inputStart, outputIndices);
    }

    public <T extends TNumber> SparseSoftmax<T> sparseSoftmax(Operand<TInt64> spIndices, Operand<T> spValues, Operand<TInt64> spShape) {
        return SparseSoftmax.create(this.scope, spIndices, spValues, spShape);
    }

    public <T extends TNumber> SparseSparseMaximum<T> sparseSparseMaximum(Operand<TInt64> aIndices, Operand<T> aValues, Operand<TInt64> aShape, Operand<TInt64> bIndices, Operand<T> bValues, Operand<TInt64> bShape) {
        return SparseSparseMaximum.create(this.scope, aIndices, aValues, aShape, bIndices, bValues, bShape);
    }

    public <T extends TType> SparseSparseMinimum<T> sparseSparseMinimum(Operand<TInt64> aIndices, Operand<T> aValues, Operand<TInt64> aShape, Operand<TInt64> bIndices, Operand<T> bValues, Operand<TInt64> bShape) {
        return SparseSparseMinimum.create(this.scope, aIndices, aValues, aShape, bIndices, bValues, bShape);
    }

    public <T extends TType> SparseSplit<T> sparseSplit(Operand<TInt64> splitDim, Operand<TInt64> indices, Operand<T> values, Operand<TInt64> shape, Long numSplit) {
        return SparseSplit.create(this.scope, splitDim, indices, values, shape, numSplit);
    }

    public <U extends TType, T extends TNumber> SparseTensorDenseAdd<U> sparseTensorDenseAdd(Operand<T> aIndices, Operand<U> aValues, Operand<T> aShape, Operand<U> b) {
        return SparseTensorDenseAdd.create(this.scope, aIndices, aValues, aShape, b);
    }

    public <U extends TType> SparseTensorDenseMatMul<U> sparseTensorDenseMatMul(Operand<? extends TNumber> aIndices, Operand<U> aValues, Operand<TInt64> aShape, Operand<U> b, SparseTensorDenseMatMul.Options ... options) {
        return SparseTensorDenseMatMul.create(this.scope, aIndices, aValues, aShape, b, options);
    }

    public <U extends TType, T extends TNumber> SparseToDense<U> sparseToDense(Operand<T> sparseIndices, Operand<T> outputShape, Operand<U> sparseValues, Operand<U> defaultValue, SparseToDense.Options ... options) {
        return SparseToDense.create(this.scope, sparseIndices, outputShape, sparseValues, defaultValue, options);
    }

    public <T extends TType> SparseToSparseSetOperation<T> sparseToSparseSetOperation(Operand<TInt64> set1Indices, Operand<T> set1Values, Operand<TInt64> set1Shape, Operand<TInt64> set2Indices, Operand<T> set2Values, Operand<TInt64> set2Shape, String setOperation, SparseToSparseSetOperation.Options ... options) {
        return SparseToSparseSetOperation.create(this.scope, set1Indices, set1Values, set1Shape, set2Indices, set2Values, set2Shape, setOperation, options);
    }

    public <T extends TType> TakeManySparseFromTensorsMap<T> takeManySparseFromTensorsMap(Operand<TInt64> sparseHandles, Class<T> dtype, TakeManySparseFromTensorsMap.Options ... options) {
        return TakeManySparseFromTensorsMap.create(this.scope, sparseHandles, dtype, options);
    }

    public final Ops ops() {
        return this.ops;
    }
}

