/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.tensorflow.RawTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.impl.dense.LongDenseNdArray;
import org.tensorflow.types.TInt64;

public final class TInt64Mapper
extends TensorMapper<TInt64> {
    @Override
    protected TInt64 mapDense(RawTensor tensor) {
        LongDataBuffer buffer = TensorBuffers.toLongs(TInt64Mapper.nativeHandle(tensor));
        return new DenseTInt64(tensor, buffer);
    }

    private static final class DenseTInt64
    extends LongDenseNdArray
    implements TInt64 {
        final RawTensor rawTensor;

        public Class<TInt64> type() {
            return TInt64.class;
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTInt64(RawTensor rawTensor, LongDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

