/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaSharding", inputsClass=Inputs.class)
public final class Sharding<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaSharding";
    private Output<T> output;

    public Sharding(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> Sharding<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Sharding");
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.sharding != null) {
                    opBuilder.setAttr("sharding", opts.sharding);
                }
                if (opts.unspecifiedDims == null) continue;
                long[] unspecifiedDimsArray = new long[opts.unspecifiedDims.size()];
                for (int i = 0; i < unspecifiedDimsArray.length; ++i) {
                    unspecifiedDimsArray[i] = (Long)opts.unspecifiedDims.get(i);
                }
                opBuilder.setAttr("unspecified_dims", unspecifiedDimsArray);
            }
        }
        return new Sharding<T>(opBuilder.build());
    }

    public static Options sharding(String sharding) {
        return new Options().sharding(sharding);
    }

    public static Options unspecifiedDims(List<Long> unspecifiedDims) {
        return new Options().unspecifiedDims(unspecifiedDims);
    }

    public static Options unspecifiedDims(Long ... unspecifiedDims) {
        return new Options().unspecifiedDims(unspecifiedDims);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Sharding.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Sharding<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final String sharding;
        public final long[] unspecifiedDims;

        public Inputs(GraphOperation op) {
            super(new Sharding(op), op, Arrays.asList("T", "sharding", "unspecified_dims"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.sharding = op.attributes().getAttrString("sharding");
            this.unspecifiedDims = op.attributes().getAttrIntList("unspecified_dims");
        }
    }

    public static class Options {
        private String sharding;
        private List<Long> unspecifiedDims;

        private Options() {
        }

        public Options sharding(String sharding) {
            this.sharding = sharding;
            return this;
        }

        public Options unspecifiedDims(List<Long> unspecifiedDims) {
            this.unspecifiedDims = unspecifiedDims;
            return this;
        }

        public Options unspecifiedDims(Long ... unspecifiedDims) {
            this.unspecifiedDims = Arrays.asList(unspecifiedDims);
            return this;
        }
    }
}

