/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;

@OpMetadata(opType="UnicodeTranscode", inputsClass=Inputs.class)
public final class UnicodeTranscode
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "UnicodeTranscode";
    private Output<TString> output;

    public UnicodeTranscode(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static UnicodeTranscode create(Scope scope, Operand<TString> input, String inputEncoding, String outputEncoding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("input_encoding", inputEncoding);
        opBuilder.setAttr("output_encoding", outputEncoding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.errors != null) {
                    opBuilder.setAttr("errors", opts.errors);
                }
                if (opts.replacementChar != null) {
                    opBuilder.setAttr("replacement_char", opts.replacementChar);
                }
                if (opts.replaceControlCharacters == null) continue;
                opBuilder.setAttr("replace_control_characters", opts.replaceControlCharacters);
            }
        }
        return new UnicodeTranscode(opBuilder.build());
    }

    public static Options errors(String errors) {
        return new Options().errors(errors);
    }

    public static Options replacementChar(Long replacementChar) {
        return new Options().replacementChar(replacementChar);
    }

    public static Options replaceControlCharacters(Boolean replaceControlCharacters) {
        return new Options().replaceControlCharacters(replaceControlCharacters);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=UnicodeTranscode.class)
    public static class Inputs
    extends RawOpInputs<UnicodeTranscode> {
        public final Operand<TString> input;
        public final String inputEncoding;
        public final String outputEncoding;
        public final String errors;
        public final long replacementChar;
        public final boolean replaceControlCharacters;

        public Inputs(GraphOperation op) {
            super(new UnicodeTranscode(op), op, Arrays.asList("input_encoding", "output_encoding", "errors", "replacement_char", "replace_control_characters"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.inputEncoding = op.attributes().getAttrString("input_encoding");
            this.outputEncoding = op.attributes().getAttrString("output_encoding");
            this.errors = op.attributes().getAttrString("errors");
            this.replacementChar = op.attributes().getAttrInt("replacement_char");
            this.replaceControlCharacters = op.attributes().getAttrBool("replace_control_characters");
        }
    }

    public static class Options {
        private String errors;
        private Long replacementChar;
        private Boolean replaceControlCharacters;

        private Options() {
        }

        public Options errors(String errors) {
            this.errors = errors;
            return this;
        }

        public Options replacementChar(Long replacementChar) {
            this.replacementChar = replacementChar;
            return this;
        }

        public Options replaceControlCharacters(Boolean replaceControlCharacters) {
            this.replaceControlCharacters = replaceControlCharacters;
            return this;
        }
    }
}

