/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;

@OpMetadata(opType="ReduceJoin", inputsClass=Inputs.class)
public final class ReduceJoin
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "ReduceJoin";
    private Output<TString> output;

    public ReduceJoin(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static ReduceJoin create(Scope scope, Operand<TString> inputs, Operand<TInt32> reductionIndices, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(reductionIndices.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.keepDims != null) {
                    opBuilder.setAttr("keep_dims", opts.keepDims);
                }
                if (opts.separator == null) continue;
                opBuilder.setAttr("separator", opts.separator);
            }
        }
        return new ReduceJoin(opBuilder.build());
    }

    public static Options keepDims(Boolean keepDims) {
        return new Options().keepDims(keepDims);
    }

    public static Options separator(String separator) {
        return new Options().separator(separator);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ReduceJoin.class)
    public static class Inputs
    extends RawOpInputs<ReduceJoin> {
        public final Operand<TString> inputs;
        public final Operand<TInt32> reductionIndices;
        public final boolean keepDims;
        public final String separator;

        public Inputs(GraphOperation op) {
            super(new ReduceJoin(op), op, Arrays.asList("keep_dims", "separator"));
            int inputIndex = 0;
            this.inputs = op.input(inputIndex++);
            this.reductionIndices = op.input(inputIndex++);
            this.keepDims = op.attributes().getAttrBool("keep_dims");
            this.separator = op.attributes().getAttrString("separator");
        }
    }

    public static class Options {
        private Boolean keepDims;
        private String separator;

        private Options() {
        }

        public Options keepDims(Boolean keepDims) {
            this.keepDims = keepDims;
            return this;
        }

        public Options separator(String separator) {
            this.separator = separator;
            return this;
        }
    }
}

