/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizedReluX", inputsClass=Inputs.class)
public final class QuantizedReluX<U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "QuantizedReluX";
    private Output<U> activations;
    private Output<TFloat32> minActivations;
    private Output<TFloat32> maxActivations;

    public QuantizedReluX(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.activations = operation.output(outputIdx++);
        this.minActivations = operation.output(outputIdx++);
        this.maxActivations = operation.output(outputIdx++);
    }

    public static <U extends TNumber> QuantizedReluX<U> create(Scope scope, Operand<? extends TNumber> features, Operand<TFloat32> maxValue, Operand<TFloat32> minFeatures, Operand<TFloat32> maxFeatures, Class<U> outType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(features.asOutput());
        opBuilder.addInput(maxValue.asOutput());
        opBuilder.addInput(minFeatures.asOutput());
        opBuilder.addInput(maxFeatures.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        return new QuantizedReluX<U>(opBuilder.build());
    }

    public Output<U> activations() {
        return this.activations;
    }

    public Output<TFloat32> minActivations() {
        return this.minActivations;
    }

    public Output<TFloat32> maxActivations() {
        return this.maxActivations;
    }

    @OpInputsMetadata(outputsClass=QuantizedReluX.class)
    public static class Inputs
    extends RawOpInputs<QuantizedReluX<?>> {
        public final Operand<? extends TNumber> features;
        public final Operand<TFloat32> maxValue;
        public final Operand<TFloat32> minFeatures;
        public final Operand<TFloat32> maxFeatures;
        public final DataType Tinput;
        public final DataType outType;

        public Inputs(GraphOperation op) {
            super(new QuantizedReluX(op), op, Arrays.asList("Tinput", "out_type"));
            int inputIndex = 0;
            this.features = op.input(inputIndex++);
            this.maxValue = op.input(inputIndex++);
            this.minFeatures = op.input(inputIndex++);
            this.maxFeatures = op.input(inputIndex++);
            this.Tinput = op.attributes().getAttrType("Tinput");
            this.outType = op.attributes().getAttrType("out_type");
        }
    }
}

