/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseMatrixZeros", inputsClass=Inputs.class)
public final class SparseMatrixZeros
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SparseMatrixZeros";
    private Output<? extends TType> sparseMatrix;

    public SparseMatrixZeros(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sparseMatrix = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseMatrixZeros create(Scope scope, Operand<TInt64> denseShape, Class<T> type) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(denseShape.asOutput());
        opBuilder.setAttr("type", Operands.toDataType(type));
        return new SparseMatrixZeros(opBuilder.build());
    }

    public Output<? extends TType> sparseMatrix() {
        return this.sparseMatrix;
    }

    @Override
    public Output<TType> asOutput() {
        return this.sparseMatrix;
    }

    @OpInputsMetadata(outputsClass=SparseMatrixZeros.class)
    public static class Inputs
    extends RawOpInputs<SparseMatrixZeros> {
        public final Operand<TInt64> denseShape;
        public final DataType type;

        public Inputs(GraphOperation op) {
            super(new SparseMatrixZeros(op), op, Arrays.asList("type"));
            int inputIndex = 0;
            this.denseShape = op.input(inputIndex++);
            this.type = op.attributes().getAttrType("type");
        }
    }
}

