/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Svd", inputsClass=Inputs.class)
public final class Svd<T extends TType>
extends RawOp {
    public static final String OP_NAME = "Svd";
    private Output<T> s;
    private Output<T> u;
    private Output<T> v;

    public Svd(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.s = operation.output(outputIdx++);
        this.u = operation.output(outputIdx++);
        this.v = operation.output(outputIdx++);
    }

    public static <T extends TType> Svd<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.computeUv != null) {
                    opBuilder.setAttr("compute_uv", opts.computeUv);
                }
                if (opts.fullMatrices == null) continue;
                opBuilder.setAttr("full_matrices", opts.fullMatrices);
            }
        }
        return new Svd<T>(opBuilder.build());
    }

    public static Options computeUv(Boolean computeUv) {
        return new Options().computeUv(computeUv);
    }

    public static Options fullMatrices(Boolean fullMatrices) {
        return new Options().fullMatrices(fullMatrices);
    }

    public Output<T> s() {
        return this.s;
    }

    public Output<T> u() {
        return this.u;
    }

    public Output<T> v() {
        return this.v;
    }

    @OpInputsMetadata(outputsClass=Svd.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Svd<T>> {
        public final Operand<T> input;
        public final boolean computeUv;
        public final boolean fullMatrices;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new Svd(op), op, Arrays.asList("compute_uv", "full_matrices", "T"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.computeUv = op.attributes().getAttrBool("compute_uv");
            this.fullMatrices = op.attributes().getAttrBool("full_matrices");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean computeUv;
        private Boolean fullMatrices;

        private Options() {
        }

        public Options computeUv(Boolean computeUv) {
            this.computeUv = computeUv;
            return this;
        }

        public Options fullMatrices(Boolean fullMatrices) {
            this.fullMatrices = fullMatrices;
            return this;
        }
    }
}

