/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="GenerateBoundingBoxProposals", inputsClass=Inputs.class)
public final class GenerateBoundingBoxProposals
extends RawOp {
    public static final String OP_NAME = "GenerateBoundingBoxProposals";
    private Output<TFloat32> rois;
    private Output<TFloat32> roiProbabilities;

    public GenerateBoundingBoxProposals(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.rois = operation.output(outputIdx++);
        this.roiProbabilities = operation.output(outputIdx++);
    }

    public static GenerateBoundingBoxProposals create(Scope scope, Operand<TFloat32> scores, Operand<TFloat32> bboxDeltas, Operand<TFloat32> imageInfo, Operand<TFloat32> anchors, Operand<TFloat32> nmsThreshold, Operand<TInt32> preNmsTopn, Operand<TFloat32> minSize, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(bboxDeltas.asOutput());
        opBuilder.addInput(imageInfo.asOutput());
        opBuilder.addInput(anchors.asOutput());
        opBuilder.addInput(nmsThreshold.asOutput());
        opBuilder.addInput(preNmsTopn.asOutput());
        opBuilder.addInput(minSize.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.postNmsTopn == null) continue;
                opBuilder.setAttr("post_nms_topn", opts.postNmsTopn);
            }
        }
        return new GenerateBoundingBoxProposals(opBuilder.build());
    }

    public static Options postNmsTopn(Long postNmsTopn) {
        return new Options().postNmsTopn(postNmsTopn);
    }

    public Output<TFloat32> rois() {
        return this.rois;
    }

    public Output<TFloat32> roiProbabilities() {
        return this.roiProbabilities;
    }

    @OpInputsMetadata(outputsClass=GenerateBoundingBoxProposals.class)
    public static class Inputs
    extends RawOpInputs<GenerateBoundingBoxProposals> {
        public final Operand<TFloat32> scores;
        public final Operand<TFloat32> bboxDeltas;
        public final Operand<TFloat32> imageInfo;
        public final Operand<TFloat32> anchors;
        public final Operand<TFloat32> nmsThreshold;
        public final Operand<TInt32> preNmsTopn;
        public final Operand<TFloat32> minSize;
        public final long postNmsTopn;

        public Inputs(GraphOperation op) {
            super(new GenerateBoundingBoxProposals(op), op, Arrays.asList("post_nms_topn"));
            int inputIndex = 0;
            this.scores = op.input(inputIndex++);
            this.bboxDeltas = op.input(inputIndex++);
            this.imageInfo = op.input(inputIndex++);
            this.anchors = op.input(inputIndex++);
            this.nmsThreshold = op.input(inputIndex++);
            this.preNmsTopn = op.input(inputIndex++);
            this.minSize = op.input(inputIndex++);
            this.postNmsTopn = op.attributes().getAttrInt("post_nms_topn");
        }
    }

    public static class Options {
        private Long postNmsTopn;

        private Options() {
        }

        public Options postNmsTopn(Long postNmsTopn) {
            this.postNmsTopn = postNmsTopn;
            return this;
        }
    }
}

