/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorListGetItem", inputsClass=Inputs.class)
public final class TensorListGetItem<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TensorListGetItem";
    private Output<T> item;

    public TensorListGetItem(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.item = operation.output(outputIdx++);
    }

    public static <T extends TType> TensorListGetItem<T> create(Scope scope, Operand<? extends TType> inputHandle, Operand<TInt32> index, Operand<TInt32> elementShape, Class<T> elementDtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder.addInput(index.asOutput());
        opBuilder.addInput(elementShape.asOutput());
        opBuilder.setAttr("element_dtype", Operands.toDataType(elementDtype));
        return new TensorListGetItem<T>(opBuilder.build());
    }

    public Output<T> item() {
        return this.item;
    }

    @Override
    public Output<T> asOutput() {
        return this.item;
    }

    @OpInputsMetadata(outputsClass=TensorListGetItem.class)
    public static class Inputs
    extends RawOpInputs<TensorListGetItem<?>> {
        public final Operand<? extends TType> inputHandle;
        public final Operand<TInt32> index;
        public final Operand<TInt32> elementShape;
        public final DataType elementDtype;

        public Inputs(GraphOperation op) {
            super(new TensorListGetItem(op), op, Arrays.asList("element_dtype"));
            int inputIndex = 0;
            this.inputHandle = op.input(inputIndex++);
            this.index = op.input(inputIndex++);
            this.elementShape = op.input(inputIndex++);
            this.elementDtype = op.attributes().getAttrType("element_dtype");
        }
    }
}

