/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Squeeze", inputsClass=Inputs.class)
public final class Squeeze<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Squeeze";
    private Output<T> output;

    public Squeeze(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> Squeeze<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.axis == null) continue;
                long[] squeezeDimsArray = new long[opts.axis.size()];
                for (int i = 0; i < squeezeDimsArray.length; ++i) {
                    squeezeDimsArray[i] = (Long)opts.axis.get(i);
                }
                opBuilder.setAttr("squeeze_dims", squeezeDimsArray);
            }
        }
        return new Squeeze<T>(opBuilder.build());
    }

    public static Options axis(List<Long> axis) {
        return new Options().axis(axis);
    }

    public static Options axis(Long ... axis) {
        return new Options().axis(axis);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Squeeze.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Squeeze<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final long[] axis;

        public Inputs(GraphOperation op) {
            super(new Squeeze(op), op, Arrays.asList("T", "squeeze_dims"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.axis = op.attributes().getAttrIntList("squeeze_dims");
        }
    }

    public static class Options {
        private List<Long> axis;

        private Options() {
        }

        public Options axis(List<Long> axis) {
            this.axis = axis;
            return this;
        }

        public Options axis(Long ... axis) {
            this.axis = Arrays.asList(axis);
            return this;
        }
    }
}

