/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ResourceCountUpTo", inputsClass=Inputs.class)
public final class ResourceCountUpTo<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ResourceCountUpTo";
    private Output<T> output;

    public ResourceCountUpTo(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> ResourceCountUpTo<T> create(Scope scope, Operand<? extends TType> resource, Long limit, Class<T> T) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(resource.asOutput());
        opBuilder.setAttr("limit", limit);
        opBuilder.setAttr("T", Operands.toDataType(T));
        return new ResourceCountUpTo<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ResourceCountUpTo.class)
    public static class Inputs
    extends RawOpInputs<ResourceCountUpTo<?>> {
        public final Operand<? extends TType> resource;
        public final long limit;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new ResourceCountUpTo(op), op, Arrays.asList("limit", "T"));
            int inputIndex = 0;
            this.resource = op.input(inputIndex++);
            this.limit = op.attributes().getAttrInt("limit");
            this.T = op.attributes().getAttrType("T");
        }
    }
}

