/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.Tensor;
import org.tensorflow.internal.types.TFloat16Mapper;
import org.tensorflow.ndarray.FloatNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.annotation.TensorType;
import org.tensorflow.types.family.TFloating;

@TensorType(dataType=DataType.DT_HALF, byteSize=2, mapperClass=TFloat16Mapper.class)
public interface TFloat16
extends FloatNdArray,
TFloating {
    public static TFloat16 scalarOf(float value) {
        return Tensor.of(TFloat16.class, Shape.scalar(), (T data) -> data.setFloat(value, new long[0]));
    }

    public static TFloat16 vectorOf(float ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(TFloat16.class, Shape.of(values.length), (T data) -> StdArrays.copyTo(values, (FloatNdArray)data));
    }

    public static TFloat16 tensorOf(NdArray<Float> src) {
        return Tensor.of(TFloat16.class, src.shape(), src::copyTo);
    }

    public static TFloat16 tensorOf(Shape shape) {
        return Tensor.of(TFloat16.class, shape);
    }

    public static TFloat16 tensorOf(Shape shape, FloatDataBuffer data) {
        return Tensor.of(TFloat16.class, shape, (T d) -> d.write(data));
    }

    public static TFloat16 tensorOf(Shape shape, Consumer<TFloat16> dataInit) {
        return Tensor.of(TFloat16.class, shape, dataInit);
    }
}

