/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.risc;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RiscReduce", inputsClass=Inputs.class)
public final class RiscReduce<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RiscReduce";
    private Output<T> output;

    public RiscReduce(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> RiscReduce<T> create(Scope scope, Operand<T> tensor, Operand<? extends TNumber> axis, String reduceType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(tensor.asOutput());
        opBuilder.addInput(axis.asOutput());
        opBuilder.setAttr("reduce_type", reduceType);
        return new RiscReduce<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RiscReduce.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<RiscReduce<T>> {
        public final Operand<T> tensor;
        public final Operand<? extends TNumber> axis;
        public final String reduceType;
        public final DataType Index;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new RiscReduce(op), op, Arrays.asList("reduce_type", "Index", "T"));
            int inputIndex = 0;
            this.tensor = op.input(inputIndex++);
            this.axis = op.input(inputIndex++);
            this.reduceType = op.attributes().getAttrString("reduce_type");
            this.Index = op.attributes().getAttrType("Index");
            this.T = op.attributes().getAttrType("T");
        }
    }
}

