/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="CudnnRNNCanonicalToParamsV2", inputsClass=Inputs.class)
public final class CudnnRNNCanonicalToParams<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CudnnRNNCanonicalToParamsV2";
    private Output<T> params;

    public CudnnRNNCanonicalToParams(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.params = operation.output(outputIdx++);
    }

    public static <T extends TNumber> CudnnRNNCanonicalToParams<T> create(Scope scope, Operand<TInt32> numLayers, Operand<TInt32> numUnits, Operand<TInt32> inputSize, Iterable<Operand<T>> weights, Iterable<Operand<T>> biases, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CudnnRNNCanonicalToParams");
        opBuilder.addInput(numLayers.asOutput());
        opBuilder.addInput(numUnits.asOutput());
        opBuilder.addInput(inputSize.asOutput());
        opBuilder.addInputList(Operands.asOutputs(weights));
        opBuilder.addInputList(Operands.asOutputs(biases));
        if (options != null) {
            for (Options opts : options) {
                if (opts.rnnMode != null) {
                    opBuilder.setAttr("rnn_mode", opts.rnnMode);
                }
                if (opts.inputMode != null) {
                    opBuilder.setAttr("input_mode", opts.inputMode);
                }
                if (opts.direction != null) {
                    opBuilder.setAttr("direction", opts.direction);
                }
                if (opts.dropout != null) {
                    opBuilder.setAttr("dropout", opts.dropout.floatValue());
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.numProj == null) continue;
                opBuilder.setAttr("num_proj", opts.numProj);
            }
        }
        return new CudnnRNNCanonicalToParams<T>(opBuilder.build());
    }

    public static Options rnnMode(String rnnMode) {
        return new Options().rnnMode(rnnMode);
    }

    public static Options inputMode(String inputMode) {
        return new Options().inputMode(inputMode);
    }

    public static Options direction(String direction) {
        return new Options().direction(direction);
    }

    public static Options dropout(Float dropout) {
        return new Options().dropout(dropout);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options numProj(Long numProj) {
        return new Options().numProj(numProj);
    }

    public Output<T> params() {
        return this.params;
    }

    @Override
    public Output<T> asOutput() {
        return this.params;
    }

    @OpInputsMetadata(outputsClass=CudnnRNNCanonicalToParams.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<CudnnRNNCanonicalToParams<T>> {
        public final Operand<TInt32> numLayers;
        public final Operand<TInt32> numUnits;
        public final Operand<TInt32> inputSize;
        public final Iterable<Operand<T>> weights;
        public final Iterable<Operand<T>> biases;
        public final DataType T;
        public final String rnnMode;
        public final String inputMode;
        public final String direction;
        public final float dropout;
        public final long seed;
        public final long seed2;
        public final long numProj;

        public Inputs(GraphOperation op) {
            super(new CudnnRNNCanonicalToParams(op), op, Arrays.asList("T", "rnn_mode", "input_mode", "direction", "dropout", "seed", "seed2", "num_proj"));
            int inputIndex = 0;
            this.numLayers = op.input(inputIndex++);
            this.numUnits = op.input(inputIndex++);
            this.inputSize = op.input(inputIndex++);
            int weightsLength = op.inputListLength("weights");
            this.weights = Arrays.asList((Operand[])op.inputList(inputIndex, weightsLength));
            int biasesLength = op.inputListLength("biases");
            this.biases = Arrays.asList((Operand[])op.inputList(inputIndex += weightsLength, biasesLength));
            inputIndex += biasesLength;
            this.T = op.attributes().getAttrType("T");
            this.rnnMode = op.attributes().getAttrString("rnn_mode");
            this.inputMode = op.attributes().getAttrString("input_mode");
            this.direction = op.attributes().getAttrString("direction");
            this.dropout = op.attributes().getAttrFloat("dropout");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
            this.numProj = op.attributes().getAttrInt("num_proj");
        }
    }

    public static class Options {
        private String rnnMode;
        private String inputMode;
        private String direction;
        private Float dropout;
        private Long seed;
        private Long seed2;
        private Long numProj;

        private Options() {
        }

        public Options rnnMode(String rnnMode) {
            this.rnnMode = rnnMode;
            return this;
        }

        public Options inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Options direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Options dropout(Float dropout) {
            this.dropout = dropout;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options numProj(Long numProj) {
            this.numProj = numProj;
            return this;
        }
    }
}

