/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="FinalizeDataset", inputsClass=Inputs.class)
public final class FinalizeDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "FinalizeDataset";
    private Output<? extends TType> handle;

    public FinalizeDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static FinalizeDataset create(Scope scope, Operand<? extends TType> inputDataset, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.hasCapturedRef == null) continue;
                opBuilder.setAttr("has_captured_ref", opts.hasCapturedRef);
            }
        }
        return new FinalizeDataset(opBuilder.build());
    }

    public static Options hasCapturedRef(Boolean hasCapturedRef) {
        return new Options().hasCapturedRef(hasCapturedRef);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=FinalizeDataset.class)
    public static class Inputs
    extends RawOpInputs<FinalizeDataset> {
        public final Operand<? extends TType> inputDataset;
        public final boolean hasCapturedRef;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new FinalizeDataset(op), op, Arrays.asList("has_captured_ref", "output_types", "output_shapes"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.hasCapturedRef = op.attributes().getAttrBool("has_captured_ref");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }

    public static class Options {
        private Boolean hasCapturedRef;

        private Options() {
        }

        public Options hasCapturedRef(Boolean hasCapturedRef) {
            this.hasCapturedRef = hasCapturedRef;
            return this;
        }
    }
}

