/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.RawTensor;
import org.tensorflow.SessionFunction;
import org.tensorflow.Signature;
import org.tensorflow.Tensor;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.internal.c_api.TF_Buffer;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_Operation;
import org.tensorflow.internal.c_api.TF_Output;
import org.tensorflow.internal.c_api.TF_Session;
import org.tensorflow.internal.c_api.TF_SessionOptions;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.internal.types.registry.TensorTypeRegistry;
import org.tensorflow.op.Op;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.ReadVariableOp;
import org.tensorflow.proto.framework.ConfigProto;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.proto.framework.RunMetadata;
import org.tensorflow.proto.framework.RunOptions;
import org.tensorflow.proto.util.SaverDef;
import org.tensorflow.types.TString;

public final class Session
implements AutoCloseable {
    private final Graph graph;
    private final Graph.Reference graphRef;
    private final Object nativeHandleLock = new Object();
    private TF_Session nativeHandle;
    private int numActiveRuns;
    private final boolean autoInit;
    private final Set<Operation> ranInits = Collections.synchronizedSet(new LinkedHashSet());

    public Session(Graph g) {
        this(g, (ConfigProto)null);
    }

    public Session(Graph g, ConfigProto config) {
        this(g, true, config);
    }

    public Session(Graph g, boolean autoInit) {
        this(g, autoInit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session(Graph g, boolean autoInit, ConfigProto config) {
        this.graph = g;
        try (Graph.Reference r = g.ref();){
            this.nativeHandle = Session.allocate(r.nativeHandle(), null, config);
            this.graphRef = g.ref();
        }
        this.autoInit = autoInit;
    }

    Session(Graph g, TF_Session nativeHandle) {
        this.graph = g;
        this.nativeHandle = nativeHandle;
        this.graphRef = g.ref();
        this.autoInit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.graphRef.close();
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == null || this.nativeHandle.isNull()) {
                return;
            }
            while (this.numActiveRuns > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Session.delete(this.nativeHandle);
            this.nativeHandle = null;
        }
    }

    public void initialize() {
        Runner runner = this.runner();
        this.graph.initializers().stream().filter(x -> !this.ranInits.contains(x)).forEach(runner::addTarget);
        this.setInitialized();
        if (!runner.isEmpty()) {
            runner.runNoInit();
        }
    }

    void setInitialized() {
        this.ranInits.clear();
        this.ranInits.addAll(this.graph.initializers());
    }

    public Session forceInitialize() {
        Set<Operation> initializers = this.graph.initializers();
        if (!initializers.isEmpty()) {
            Runner runner = this.runner();
            initializers.forEach(runner::addTarget);
            runner.runNoInit();
        }
        this.ranInits.clear();
        this.ranInits.addAll(this.graph.initializers());
        return this;
    }

    public Runner runner() {
        return new Runner();
    }

    public void run(String opName) {
        this.runner().addTarget(opName).run();
    }

    public void run(Op op) {
        this.runner().addTarget(op.op()).run();
    }

    public SessionFunction function(Signature signature) {
        return new SessionFunction(signature, this);
    }

    public Map<String, Tensor> run(Signature signature, Map<String, Tensor> arguments) {
        return this.function(signature).call(arguments);
    }

    public void save(String prefix) {
        SaverDef saverDef = this.graph.saverDef();
        this.runner().addTarget(saverDef.getSaveTensorName()).feed(saverDef.getFilenameTensorName(), (Tensor)TString.scalarOf(prefix)).run();
    }

    public void restore(String prefix) {
        SaverDef saverDef = this.graph.saverDef();
        this.runner().addTarget(saverDef.getRestoreOpName()).feed(saverDef.getFilenameTensorName(), (Tensor)TString.scalarOf(prefix)).runNoInit();
        this.setInitialized();
    }

    Graph graph() {
        return this.graph;
    }

    private static void requireHandle(Pointer handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("close() has been called on the Session");
        }
    }

    private static void resolveHandles(String type, Pointer[] src, PointerPointer dst, int n) {
        if (src.length != n) {
            throw new IllegalArgumentException("expected " + n + ", got " + src.length + " " + type);
        }
        for (int i = 0; i < n; ++i) {
            if (src[i] == null || src[i].isNull()) {
                throw new IllegalStateException("invalid " + type + " (#" + i + " of " + n + ")");
            }
            dst.put((long)i, src[i]);
        }
    }

    private static TF_Session allocate(TF_Graph graphHandle, String target, ConfigProto config) {
        if (graphHandle == null || graphHandle.isNull()) {
            throw new IllegalStateException("Graph has been close()d");
        }
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            TF_SessionOptions opts = TF_SessionOptions.newSessionOptions();
            if (config != null) {
                BytePointer configBytes = new BytePointer(config.toByteArray());
                tensorflow.TF_SetConfig(opts, (Pointer)configBytes, configBytes.capacity(), status);
                status.throwExceptionIfNotOK();
            }
            TF_Session session = TF_Session.newSession(graphHandle, opts, status);
            status.throwExceptionIfNotOK();
            TF_Session tF_Session = (TF_Session)session.retainReference();
            return tF_Session;
        }
    }

    private static void delete(TF_Session handle) {
        Session.requireHandle(handle);
        handle.releaseReference();
    }

    private static RunMetadata run(TF_Session handle, RunOptions runOptions, TF_Tensor[] inputTensorHandles, TF_Operation[] inputOpHandles, int[] inputOpIndices, TF_Operation[] outputOpHandles, int[] outputOpIndices, TF_Operation[] targetOpHandles, boolean wantRunMetadata, List<Tensor> outputTensors) {
        Session.requireHandle(handle);
        int ninputs = inputTensorHandles.length;
        int noutputs = outputOpHandles.length;
        int ntargets = targetOpHandles.length;
        Throwable throwable = null;
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Output inputs = new TF_Output(ninputs);
            PointerPointer inputValues = new PointerPointer((long)ninputs);
            TF_Output outputs = new TF_Output(noutputs);
            PointerPointer outputValues = new PointerPointer((long)noutputs);
            PointerPointer targets = new PointerPointer((long)ntargets);
            TF_Buffer runMetadata = wantRunMetadata ? TF_Buffer.newBuffer() : null;
            Session.resolveHandles("input Tensors", inputTensorHandles, inputValues, ninputs);
            Graph.resolveOutputs("input", inputOpHandles, inputOpIndices, inputs, ninputs);
            Graph.resolveOutputs("output", outputOpHandles, outputOpIndices, outputs, noutputs);
            Session.resolveHandles("target Operations", targetOpHandles, targets, ntargets);
            TF_Status status = TF_Status.newStatus();
            TF_Buffer runOpts = TF_Buffer.newBufferFromString((Message)runOptions);
            tensorflow.TF_SessionRun(handle, runOpts, inputs, inputValues, ninputs, outputs, outputValues, noutputs, targets, ntargets, runMetadata, status);
            status.throwExceptionIfNotOK();
            for (int i = 0; i < noutputs; ++i) {
                TF_Tensor h = ((TF_Tensor)outputValues.get(TF_Tensor.class, (long)i)).withDeallocator();
                outputTensors.add(RawTensor.fromHandle(h).asTypedTensor());
            }
            try {
                RunMetadata i = runMetadata != null ? RunMetadata.parseFrom(runMetadata.dataAsByteBuffer()) : null;
                return i;
            }
            catch (InvalidProtocolBufferException e) {
                try {
                    throw new TensorFlowException("Cannot parse RunMetadata protocol buffer", e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public static final class Run {
        public List<Tensor> outputs;
        public RunMetadata metadata;
    }

    public final class Runner {
        private final ArrayList<Output<?>> inputs = new ArrayList();
        private final ArrayList<Tensor> inputTensors = new ArrayList();
        private final ArrayList<Output<?>> outputs = new ArrayList();
        private final ArrayList<GraphOperation> targets = new ArrayList();
        private RunOptions runOptions = null;

        public Runner feed(String operation, Tensor t) {
            return this.feed(Session.this.graph.outputOrThrow(operation), t);
        }

        public Runner feed(String operation, int index, Tensor t) {
            GraphOperation op = Session.this.graph.operationOrThrow(operation);
            this.inputs.add(op.output(index));
            this.inputTensors.add(t);
            return this;
        }

        public Runner feed(Operand<?> operand, Tensor t) {
            if (operand.env() != Session.this.graph) {
                throw new IllegalStateException("Can't feed value for operand " + operand + ", it is from " + (operand.env().isEager() ? "an eager session" : "a different graph") + ".");
            }
            this.inputs.add(operand.asOutput());
            this.inputTensors.add(t);
            return this;
        }

        public Runner fetch(String operation) {
            return this.fetch(Session.this.graph.outputOrThrow(operation));
        }

        public Runner fetch(String operation, int index) {
            GraphOperation op = Session.this.graph.operationOrThrow(operation);
            return this.fetch(op.output(index));
        }

        public Runner fetch(Output<?> output) {
            if (output.env() != Session.this.graph) {
                throw new IllegalStateException("Can't fetch output " + output + ", it is from " + (output.env().isEager() ? "an eager session" : "a different graph") + ".");
            }
            if (output.dataType() == DataType.DT_RESOURCE) {
                int[] rawDt = new int[1];
                GraphOperation graphOp = (GraphOperation)output.op();
                try (PointerScope scope = new PointerScope(new Class[0]);){
                    TF_Status status = TF_Status.newStatus();
                    tensorflow.TF_OperationGetAttrType(graphOp.getUnsafeNativeHandle(), "dtype", rawDt, status);
                    status.throwExceptionIfNotOK();
                }
                DataType valueDt = DataType.forNumber(rawDt[0]);
                ReadVariableOp read = null;
                for (GraphOperation op : graphOp.consumers()) {
                    if (op.dtype(0) != valueDt || !op.type().equals("ReadVariableOp")) continue;
                    read = op.output(0);
                    break;
                }
                if (read == null) {
                    read = Ops.create(Session.this.graph).withSubScope("session_reads").withName(output.op().name() + "_read").readVariableOp(output, TensorTypeRegistry.find(valueDt).type());
                }
                this.outputs.add(read.asOutput());
            } else {
                this.outputs.add(output);
            }
            return this;
        }

        public Runner fetch(Operand<?> operand) {
            return this.fetch(operand.asOutput());
        }

        public Runner addTarget(String operation) {
            return this.addTarget(Session.this.graph.outputOrThrow(operation));
        }

        public Runner addTarget(Operation operation) {
            if (operation.env() != Session.this.graph) {
                throw new IllegalStateException("Can't target operation " + operation + ", it is from " + (operation.env().isEager() ? "an eager session" : "a different graph") + ".");
            }
            this.targets.add((GraphOperation)operation);
            return this;
        }

        public Runner addTarget(Op op) {
            return this.addTarget(op.op());
        }

        public Runner setOptions(RunOptions options) {
            this.runOptions = options;
            return this;
        }

        public boolean isEmpty() {
            return this.targets.isEmpty() && this.outputs.isEmpty();
        }

        private void doInit() {
            if (Session.this.autoInit) {
                Session.this.initialize();
            } else {
                Session.this.graph.initializers().forEach(x -> {
                    if (!Session.this.ranInits.contains(x)) {
                        throw new IllegalStateException("Graph has un-ran initializers, but the session's autoInit is false.  Run Session.initialize() before calling run().");
                    }
                });
            }
        }

        public List<Tensor> run() {
            this.doInit();
            return this.runNoInit();
        }

        List<Tensor> runNoInit() {
            return this.runHelper((boolean)false).outputs;
        }

        public Run runAndFetchMetadata() {
            this.doInit();
            return this.runHelper(true);
        }

        private Run runHelper(boolean wantMetadata) {
            RunMetadata runMetadata;
            TF_Tensor[] inputTensorHandles = new TF_Tensor[this.inputTensors.size()];
            TF_Operation[] inputOpHandles = new TF_Operation[this.inputs.size()];
            int[] inputOpIndices = new int[this.inputs.size()];
            TF_Operation[] outputOpHandles = new TF_Operation[this.outputs.size()];
            int[] outputOpIndices = new int[this.outputs.size()];
            TF_Operation[] targetOpHandles = new TF_Operation[this.targets.size()];
            int idx = 0;
            for (Tensor tensor : this.inputTensors) {
                inputTensorHandles[idx++] = tensor.asRawTensor().nativeHandle();
            }
            idx = 0;
            for (Output output : this.inputs) {
                inputOpHandles[idx] = (TF_Operation)output.getUnsafeNativeHandle();
                inputOpIndices[idx] = output.index();
                ++idx;
            }
            idx = 0;
            for (Output output : this.outputs) {
                outputOpHandles[idx] = (TF_Operation)output.getUnsafeNativeHandle();
                outputOpIndices[idx] = output.index();
                ++idx;
            }
            idx = 0;
            for (GraphOperation graphOperation : this.targets) {
                targetOpHandles[idx++] = graphOperation.getUnsafeNativeHandle();
            }
            Reference runRef = new Reference();
            Object var10_17 = null;
            ArrayList<Tensor> outputs = new ArrayList<Tensor>();
            try {
                runMetadata = Session.run(Session.this.nativeHandle, this.runOptions, inputTensorHandles, inputOpHandles, inputOpIndices, outputOpHandles, outputOpIndices, targetOpHandles, wantMetadata, outputs);
            }
            catch (Exception e) {
                for (Tensor t : outputs) {
                    t.close();
                }
                outputs.clear();
                throw e;
            }
            finally {
                runRef.close();
            }
            Run ret = new Run();
            ret.outputs = outputs;
            ret.metadata = runMetadata;
            return ret;
        }

        private class Reference
        implements AutoCloseable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Reference() {
                Object object = Session.this.nativeHandleLock;
                synchronized (object) {
                    if (Session.this.nativeHandle == null || Session.this.nativeHandle.isNull()) {
                        throw new IllegalStateException("run() cannot be called on the Session after close()");
                    }
                    ++Session.this.numActiveRuns;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Object object = Session.this.nativeHandleLock;
                synchronized (object) {
                    if (Session.this.nativeHandle == null || Session.this.nativeHandle.isNull()) {
                        return;
                    }
                    if (--Session.this.numActiveRuns == 0) {
                        Session.this.nativeHandleLock.notifyAll();
                    }
                }
            }
        }
    }
}

