/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.risc;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RiscGather", inputsClass=Inputs.class)
public final class RiscGather<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RiscGather";
    private Output<T> output;

    public RiscGather(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> RiscGather<T> create(Scope scope, Operand<T> params, Operand<? extends TNumber> indices, Operand<? extends TNumber> axis, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(params.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(axis.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.batchDims == null) continue;
                opBuilder.setAttr("batch_dims", opts.batchDims);
            }
        }
        return new RiscGather<T>(opBuilder.build());
    }

    public static Options batchDims(Long batchDims) {
        return new Options().batchDims(batchDims);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RiscGather.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<RiscGather<T>> {
        public final Operand<T> params;
        public final Operand<? extends TNumber> indices;
        public final Operand<? extends TNumber> axis;
        public final long batchDims;
        public final DataType Tparams;
        public final DataType Tindices;
        public final DataType Taxis;

        public Inputs(GraphOperation op) {
            super(new RiscGather(op), op, Arrays.asList("batch_dims", "Tparams", "Tindices", "Taxis"));
            int inputIndex = 0;
            this.params = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.axis = op.input(inputIndex++);
            this.batchDims = op.attributes().getAttrInt("batch_dims");
            this.Tparams = op.attributes().getAttrType("Tparams");
            this.Tindices = op.attributes().getAttrType("Tindices");
            this.Taxis = op.attributes().getAttrType("Taxis");
        }
    }

    public static class Options {
        private Long batchDims;

        private Options() {
        }

        public Options batchDims(Long batchDims) {
            this.batchDims = batchDims;
            return this;
        }
    }
}

