/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BoostedTreesTrainingPredict", inputsClass=Inputs.class)
public final class BoostedTreesTrainingPredict
extends RawOp {
    public static final String OP_NAME = "BoostedTreesTrainingPredict";
    private Output<TFloat32> partialLogits;
    private Output<TInt32> treeIds;
    private Output<TInt32> nodeIds;

    public BoostedTreesTrainingPredict(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.partialLogits = operation.output(outputIdx++);
        this.treeIds = operation.output(outputIdx++);
        this.nodeIds = operation.output(outputIdx++);
    }

    public static BoostedTreesTrainingPredict create(Scope scope, Operand<? extends TType> treeEnsembleHandle, Operand<TInt32> cachedTreeIds, Operand<TInt32> cachedNodeIds, Iterable<Operand<TInt32>> bucketizedFeatures, Long logitsDimension) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(treeEnsembleHandle.asOutput());
        opBuilder.addInput(cachedTreeIds.asOutput());
        opBuilder.addInput(cachedNodeIds.asOutput());
        opBuilder.addInputList(Operands.asOutputs(bucketizedFeatures));
        opBuilder.setAttr("logits_dimension", logitsDimension);
        return new BoostedTreesTrainingPredict(opBuilder.build());
    }

    public Output<TFloat32> partialLogits() {
        return this.partialLogits;
    }

    public Output<TInt32> treeIds() {
        return this.treeIds;
    }

    public Output<TInt32> nodeIds() {
        return this.nodeIds;
    }

    @OpInputsMetadata(outputsClass=BoostedTreesTrainingPredict.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesTrainingPredict> {
        public final Operand<? extends TType> treeEnsembleHandle;
        public final Operand<TInt32> cachedTreeIds;
        public final Operand<TInt32> cachedNodeIds;
        public final Iterable<Operand<TInt32>> bucketizedFeatures;
        public final long logitsDimension;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesTrainingPredict(op), op, Arrays.asList("logits_dimension"));
            int inputIndex = 0;
            this.treeEnsembleHandle = op.input(inputIndex++);
            this.cachedTreeIds = op.input(inputIndex++);
            this.cachedNodeIds = op.input(inputIndex++);
            int bucketizedFeaturesLength = op.inputListLength("bucketized_features");
            this.bucketizedFeatures = Arrays.asList((Operand[])op.inputList(inputIndex, bucketizedFeaturesLength));
            inputIndex += bucketizedFeaturesLength;
            this.logitsDimension = op.attributes().getAttrInt("logits_dimension");
        }
    }
}

