/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;

@OpMetadata(opType="BoostedTreesSparseCalculateBestFeatureSplit", inputsClass=Inputs.class)
public final class BoostedTreesSparseCalculateBestFeatureSplit
extends RawOp {
    public static final String OP_NAME = "BoostedTreesSparseCalculateBestFeatureSplit";
    private Output<TInt32> nodeIds;
    private Output<TFloat32> gains;
    private Output<TInt32> featureDimensions;
    private Output<TInt32> thresholds;
    private Output<TFloat32> leftNodeContribs;
    private Output<TFloat32> rightNodeContribs;
    private Output<TString> splitWithDefaultDirections;

    public BoostedTreesSparseCalculateBestFeatureSplit(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.nodeIds = operation.output(outputIdx++);
        this.gains = operation.output(outputIdx++);
        this.featureDimensions = operation.output(outputIdx++);
        this.thresholds = operation.output(outputIdx++);
        this.leftNodeContribs = operation.output(outputIdx++);
        this.rightNodeContribs = operation.output(outputIdx++);
        this.splitWithDefaultDirections = operation.output(outputIdx++);
    }

    public static BoostedTreesSparseCalculateBestFeatureSplit create(Scope scope, Operand<TInt32> nodeIdRange, Operand<TInt32> statsSummaryIndices, Operand<TFloat32> statsSummaryValues, Operand<TInt32> statsSummaryShape, Operand<TFloat32> l1, Operand<TFloat32> l2, Operand<TFloat32> treeComplexity, Operand<TFloat32> minNodeWeight, Long logitsDimension, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(nodeIdRange.asOutput());
        opBuilder.addInput(statsSummaryIndices.asOutput());
        opBuilder.addInput(statsSummaryValues.asOutput());
        opBuilder.addInput(statsSummaryShape.asOutput());
        opBuilder.addInput(l1.asOutput());
        opBuilder.addInput(l2.asOutput());
        opBuilder.addInput(treeComplexity.asOutput());
        opBuilder.addInput(minNodeWeight.asOutput());
        opBuilder.setAttr("logits_dimension", logitsDimension);
        if (options != null) {
            for (Options opts : options) {
                if (opts.splitType == null) continue;
                opBuilder.setAttr("split_type", opts.splitType);
            }
        }
        return new BoostedTreesSparseCalculateBestFeatureSplit(opBuilder.build());
    }

    public static Options splitType(String splitType) {
        return new Options().splitType(splitType);
    }

    public Output<TInt32> nodeIds() {
        return this.nodeIds;
    }

    public Output<TFloat32> gains() {
        return this.gains;
    }

    public Output<TInt32> featureDimensions() {
        return this.featureDimensions;
    }

    public Output<TInt32> thresholds() {
        return this.thresholds;
    }

    public Output<TFloat32> leftNodeContribs() {
        return this.leftNodeContribs;
    }

    public Output<TFloat32> rightNodeContribs() {
        return this.rightNodeContribs;
    }

    public Output<TString> splitWithDefaultDirections() {
        return this.splitWithDefaultDirections;
    }

    @OpInputsMetadata(outputsClass=BoostedTreesSparseCalculateBestFeatureSplit.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesSparseCalculateBestFeatureSplit> {
        public final Operand<TInt32> nodeIdRange;
        public final Operand<TInt32> statsSummaryIndices;
        public final Operand<TFloat32> statsSummaryValues;
        public final Operand<TInt32> statsSummaryShape;
        public final Operand<TFloat32> l1;
        public final Operand<TFloat32> l2;
        public final Operand<TFloat32> treeComplexity;
        public final Operand<TFloat32> minNodeWeight;
        public final long logitsDimension;
        public final String splitType;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesSparseCalculateBestFeatureSplit(op), op, Arrays.asList("logits_dimension", "split_type"));
            int inputIndex = 0;
            this.nodeIdRange = op.input(inputIndex++);
            this.statsSummaryIndices = op.input(inputIndex++);
            this.statsSummaryValues = op.input(inputIndex++);
            this.statsSummaryShape = op.input(inputIndex++);
            this.l1 = op.input(inputIndex++);
            this.l2 = op.input(inputIndex++);
            this.treeComplexity = op.input(inputIndex++);
            this.minNodeWeight = op.input(inputIndex++);
            this.logitsDimension = op.attributes().getAttrInt("logits_dimension");
            this.splitType = op.attributes().getAttrString("split_type");
        }
    }

    public static class Options {
        private String splitType;

        private Options() {
        }

        public Options splitType(String splitType) {
            this.splitType = splitType;
            return this;
        }
    }
}

