/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.collective;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CollectiveAllToAllV3", inputsClass=Inputs.class)
public final class CollectiveAllToAll<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CollectiveAllToAllV3";
    private Output<T> data;

    public CollectiveAllToAll(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.data = operation.output(outputIdx++);
    }

    public static <T extends TNumber> CollectiveAllToAll<T> create(Scope scope, Operand<T> input, Operand<? extends TType> communicator, Operand<TInt32> groupAssignment, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CollectiveAllToAll");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(communicator.asOutput());
        opBuilder.addInput(groupAssignment.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.timeoutSeconds == null) continue;
                opBuilder.setAttr("timeout_seconds", opts.timeoutSeconds.floatValue());
            }
        }
        return new CollectiveAllToAll<T>(opBuilder.build());
    }

    public static Options timeoutSeconds(Float timeoutSeconds) {
        return new Options().timeoutSeconds(timeoutSeconds);
    }

    public Output<T> data() {
        return this.data;
    }

    @Override
    public Output<T> asOutput() {
        return this.data;
    }

    @OpInputsMetadata(outputsClass=CollectiveAllToAll.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<CollectiveAllToAll<T>> {
        public final Operand<T> input;
        public final Operand<? extends TType> communicator;
        public final Operand<TInt32> groupAssignment;
        public final DataType T;
        public final float timeoutSeconds;

        public Inputs(GraphOperation op) {
            super(new CollectiveAllToAll(op), op, Arrays.asList("T", "timeout_seconds"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.communicator = op.input(inputIndex++);
            this.groupAssignment = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.timeoutSeconds = op.attributes().getAttrFloat("timeout_seconds");
        }
    }

    public static class Options {
        private Float timeoutSeconds;

        private Options() {
        }

        public Options timeoutSeconds(Float timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }
    }
}

