/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ParseExampleDatasetV2", inputsClass=Inputs.class)
public final class ParseExampleDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ParseExampleDatasetV2";
    private Output<? extends TType> handle;

    public ParseExampleDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static ParseExampleDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> numParallelCalls, Iterable<Operand<?>> denseDefaults, List<String> sparseKeys, List<String> denseKeys, List<Class<? extends TType>> sparseTypes, List<Shape> denseShapes, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, List<Class<? extends TType>> raggedValueTypes, List<Class<? extends TNumber>> raggedSplitTypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ParseExampleDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numParallelCalls.asOutput());
        opBuilder.addInputList(Operands.asOutputs(denseDefaults));
        String[] sparseKeysArray = new String[sparseKeys.size()];
        for (int i = 0; i < sparseKeysArray.length; ++i) {
            sparseKeysArray[i] = sparseKeys.get(i);
        }
        opBuilder.setAttr("sparse_keys", sparseKeysArray);
        String[] denseKeysArray = new String[denseKeys.size()];
        for (int i = 0; i < denseKeysArray.length; ++i) {
            denseKeysArray[i] = denseKeys.get(i);
        }
        opBuilder.setAttr("dense_keys", denseKeysArray);
        opBuilder.setAttr("sparse_types", Operands.toDataTypes(sparseTypes));
        Shape[] denseShapesArray = new Shape[denseShapes.size()];
        for (int i = 0; i < denseShapesArray.length; ++i) {
            denseShapesArray[i] = denseShapes.get(i);
        }
        opBuilder.setAttr("dense_shapes", denseShapesArray);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        opBuilder.setAttr("ragged_value_types", Operands.toDataTypes(raggedValueTypes));
        opBuilder.setAttr("ragged_split_types", Operands.toDataTypes(raggedSplitTypes));
        if (options != null) {
            for (Options opts : options) {
                if (opts.deterministic != null) {
                    opBuilder.setAttr("deterministic", opts.deterministic);
                }
                if (opts.raggedKeys == null) continue;
                String[] raggedKeysArray = new String[opts.raggedKeys.size()];
                for (int i = 0; i < raggedKeysArray.length; ++i) {
                    raggedKeysArray[i] = (String)opts.raggedKeys.get(i);
                }
                opBuilder.setAttr("ragged_keys", raggedKeysArray);
            }
        }
        return new ParseExampleDataset(opBuilder.build());
    }

    public static Options deterministic(String deterministic) {
        return new Options().deterministic(deterministic);
    }

    public static Options raggedKeys(List<String> raggedKeys) {
        return new Options().raggedKeys(raggedKeys);
    }

    public static Options raggedKeys(String ... raggedKeys) {
        return new Options().raggedKeys(raggedKeys);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=ParseExampleDataset.class)
    public static class Inputs
    extends RawOpInputs<ParseExampleDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> numParallelCalls;
        public final Iterable<Operand<?>> denseDefaults;
        public final String[] sparseKeys;
        public final String[] denseKeys;
        public final DataType[] sparseTypes;
        public final DataType[] Tdense;
        public final Shape[] denseShapes;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String deterministic;
        public final String[] raggedKeys;
        public final DataType[] raggedValueTypes;
        public final DataType[] raggedSplitTypes;

        public Inputs(GraphOperation op) {
            super(new ParseExampleDataset(op), op, Arrays.asList("sparse_keys", "dense_keys", "sparse_types", "Tdense", "dense_shapes", "output_types", "output_shapes", "deterministic", "ragged_keys", "ragged_value_types", "ragged_split_types"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.numParallelCalls = op.input(inputIndex++);
            int denseDefaultsLength = op.inputListLength("dense_defaults");
            this.denseDefaults = Arrays.asList((Operand[])op.inputList(inputIndex, denseDefaultsLength));
            inputIndex += denseDefaultsLength;
            this.sparseKeys = op.attributes().getAttrStringList("sparse_keys");
            this.denseKeys = op.attributes().getAttrStringList("dense_keys");
            this.sparseTypes = op.attributes().getAttrTypeList("sparse_types");
            this.Tdense = op.attributes().getAttrTypeList("Tdense");
            this.denseShapes = op.attributes().getAttrShapeList("dense_shapes");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.deterministic = op.attributes().getAttrString("deterministic");
            this.raggedKeys = op.attributes().getAttrStringList("ragged_keys");
            this.raggedValueTypes = op.attributes().getAttrTypeList("ragged_value_types");
            this.raggedSplitTypes = op.attributes().getAttrTypeList("ragged_split_types");
        }
    }

    public static class Options {
        private String deterministic;
        private List<String> raggedKeys;

        private Options() {
        }

        public Options deterministic(String deterministic) {
            this.deterministic = deterministic;
            return this;
        }

        public Options raggedKeys(List<String> raggedKeys) {
            this.raggedKeys = raggedKeys;
            return this;
        }

        public Options raggedKeys(String ... raggedKeys) {
            this.raggedKeys = Arrays.asList(raggedKeys);
            return this;
        }
    }
}

