/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;

public final class RecordInput
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "RecordInput";
    private Output<TString> records;

    public static RecordInput create(Scope scope, String filePattern, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("file_pattern", filePattern);
        if (options != null) {
            for (Options opts : options) {
                if (opts.fileRandomSeed != null) {
                    opBuilder.setAttr("file_random_seed", opts.fileRandomSeed);
                }
                if (opts.fileShuffleShiftRatio != null) {
                    opBuilder.setAttr("file_shuffle_shift_ratio", opts.fileShuffleShiftRatio.floatValue());
                }
                if (opts.fileBufferSize != null) {
                    opBuilder.setAttr("file_buffer_size", opts.fileBufferSize);
                }
                if (opts.fileParallelism != null) {
                    opBuilder.setAttr("file_parallelism", opts.fileParallelism);
                }
                if (opts.batchSize != null) {
                    opBuilder.setAttr("batch_size", opts.batchSize);
                }
                if (opts.compressionType == null) continue;
                opBuilder.setAttr("compression_type", opts.compressionType);
            }
        }
        return new RecordInput(opBuilder.build());
    }

    public static Options fileRandomSeed(Long fileRandomSeed) {
        return new Options().fileRandomSeed(fileRandomSeed);
    }

    public static Options fileShuffleShiftRatio(Float fileShuffleShiftRatio) {
        return new Options().fileShuffleShiftRatio(fileShuffleShiftRatio);
    }

    public static Options fileBufferSize(Long fileBufferSize) {
        return new Options().fileBufferSize(fileBufferSize);
    }

    public static Options fileParallelism(Long fileParallelism) {
        return new Options().fileParallelism(fileParallelism);
    }

    public static Options batchSize(Long batchSize) {
        return new Options().batchSize(batchSize);
    }

    public static Options compressionType(String compressionType) {
        return new Options().compressionType(compressionType);
    }

    public Output<TString> records() {
        return this.records;
    }

    @Override
    public Output<TString> asOutput() {
        return this.records;
    }

    private RecordInput(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.records = operation.output(outputIdx++);
    }

    public static class Options {
        private Long fileRandomSeed;
        private Float fileShuffleShiftRatio;
        private Long fileBufferSize;
        private Long fileParallelism;
        private Long batchSize;
        private String compressionType;

        public Options fileRandomSeed(Long fileRandomSeed) {
            this.fileRandomSeed = fileRandomSeed;
            return this;
        }

        public Options fileShuffleShiftRatio(Float fileShuffleShiftRatio) {
            this.fileShuffleShiftRatio = fileShuffleShiftRatio;
            return this;
        }

        public Options fileBufferSize(Long fileBufferSize) {
            this.fileBufferSize = fileBufferSize;
            return this;
        }

        public Options fileParallelism(Long fileParallelism) {
            this.fileParallelism = fileParallelism;
            return this;
        }

        public Options batchSize(Long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Options compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        private Options() {
        }
    }
}

