/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class ExecuteAndUpdateVariables
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "TPUExecuteAndUpdateVariables";
    private List<Output<?>> results;

    public static ExecuteAndUpdateVariables create(Scope scope, Iterable<Operand<?>> args, Operand<TString> key, List<Class<? extends TType>> Tresults, List<Long> deviceVarReadsIndices, List<Long> deviceVarUpdatesIndices) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("ExecuteAndUpdateVariables"));
        opBuilder.addInputList(Operands.asOutputs(args));
        opBuilder.addInput(key.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("Tresults", Operands.toDataTypes(Tresults));
        long[] deviceVarReadsIndicesArray = new long[deviceVarReadsIndices.size()];
        for (int i = 0; i < deviceVarReadsIndicesArray.length; ++i) {
            deviceVarReadsIndicesArray[i] = deviceVarReadsIndices.get(i);
        }
        opBuilder.setAttr("device_var_reads_indices", deviceVarReadsIndicesArray);
        long[] deviceVarUpdatesIndicesArray = new long[deviceVarUpdatesIndices.size()];
        for (int i = 0; i < deviceVarUpdatesIndicesArray.length; ++i) {
            deviceVarUpdatesIndicesArray[i] = deviceVarUpdatesIndices.get(i);
        }
        opBuilder.setAttr("device_var_updates_indices", deviceVarUpdatesIndicesArray);
        return new ExecuteAndUpdateVariables(opBuilder.build());
    }

    public List<Output<?>> results() {
        return this.results;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.results.iterator();
    }

    private ExecuteAndUpdateVariables(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int resultsLength = operation.outputListLength("results");
        this.results = Arrays.asList(operation.outputList(outputIdx, resultsLength));
        outputIdx += resultsLength;
    }
}

