/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.collective;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class BroadcastSend<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CollectiveBcastSend";
    private Output<T> data;

    public static <T extends TType> BroadcastSend<T> create(Scope scope, Operand<T> input, Long groupSize, Long groupKey, Long instanceKey, Shape shape, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("BroadcastSend"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("group_size", groupSize);
        opBuilder.setAttr("group_key", groupKey);
        opBuilder.setAttr("instance_key", instanceKey);
        opBuilder.setAttr("shape", shape);
        if (options != null) {
            for (Options opts : options) {
                if (opts.communicationHint != null) {
                    opBuilder.setAttr("communication_hint", opts.communicationHint);
                }
                if (opts.timeoutSeconds == null) continue;
                opBuilder.setAttr("timeout_seconds", opts.timeoutSeconds.floatValue());
            }
        }
        return new BroadcastSend<T>(opBuilder.build());
    }

    public static Options communicationHint(String communicationHint) {
        return new Options().communicationHint(communicationHint);
    }

    public static Options timeoutSeconds(Float timeoutSeconds) {
        return new Options().timeoutSeconds(timeoutSeconds);
    }

    public Output<T> data() {
        return this.data;
    }

    @Override
    public Output<T> asOutput() {
        return this.data;
    }

    private BroadcastSend(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.data = operation.output(outputIdx++);
    }

    public static class Options {
        private String communicationHint;
        private Float timeoutSeconds;

        public Options communicationHint(String communicationHint) {
            this.communicationHint = communicationHint;
            return this;
        }

        public Options timeoutSeconds(Float timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        private Options() {
        }
    }
}

