/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class PrefetchDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "PrefetchDataset";
    private Output<?> handle;

    public static PrefetchDataset create(Scope scope, Operand<?> inputDataset, Operand<TInt64> bufferSize, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(bufferSize.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.slackPeriod != null) {
                    opBuilder.setAttr("slack_period", opts.slackPeriod);
                }
                if (opts.legacyAutotune != null) {
                    opBuilder.setAttr("legacy_autotune", opts.legacyAutotune);
                }
                if (opts.bufferSizeMin == null) continue;
                opBuilder.setAttr("buffer_size_min", opts.bufferSizeMin);
            }
        }
        return new PrefetchDataset(opBuilder.build());
    }

    public static Options slackPeriod(Long slackPeriod) {
        return new Options().slackPeriod(slackPeriod);
    }

    public static Options legacyAutotune(Boolean legacyAutotune) {
        return new Options().legacyAutotune(legacyAutotune);
    }

    public static Options bufferSizeMin(Long bufferSizeMin) {
        return new Options().bufferSizeMin(bufferSizeMin);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private PrefetchDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Long slackPeriod;
        private Boolean legacyAutotune;
        private Long bufferSizeMin;

        public Options slackPeriod(Long slackPeriod) {
            this.slackPeriod = slackPeriod;
            return this;
        }

        public Options legacyAutotune(Boolean legacyAutotune) {
            this.legacyAutotune = legacyAutotune;
            return this;
        }

        public Options bufferSizeMin(Long bufferSizeMin) {
            this.bufferSizeMin = bufferSizeMin;
            return this;
        }

        private Options() {
        }
    }
}

