/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class Restore
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "RestoreV2";
    private List<Output<?>> tensors;

    public static Restore create(Scope scope, Operand<TString> prefix, Operand<TString> tensorNames, Operand<TString> shapeAndSlices, List<Class<? extends TType>> dtypes) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("Restore"));
        opBuilder.addInput(prefix.asOutput());
        opBuilder.addInput(tensorNames.asOutput());
        opBuilder.addInput(shapeAndSlices.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("dtypes", Operands.toDataTypes(dtypes));
        return new Restore(opBuilder.build());
    }

    public List<Output<?>> tensors() {
        return this.tensors;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.tensors.iterator();
    }

    private Restore(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int tensorsLength = operation.outputListLength("tensors");
        this.tensors = Arrays.asList(operation.outputList(outputIdx, tensorsLength));
        outputIdx += tensorsLength;
    }
}

