/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class ModelDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ModelDataset";
    private Output<?> handle;

    public static ModelDataset create(Scope scope, Operand<?> inputDataset, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.algorithm != null) {
                    opBuilder.setAttr("algorithm", opts.algorithm);
                }
                if (opts.cpuBudget != null) {
                    opBuilder.setAttr("cpu_budget", opts.cpuBudget);
                }
                if (opts.ramBudget == null) continue;
                opBuilder.setAttr("ram_budget", opts.ramBudget);
            }
        }
        return new ModelDataset(opBuilder.build());
    }

    public static Options algorithm(Long algorithm) {
        return new Options().algorithm(algorithm);
    }

    public static Options cpuBudget(Long cpuBudget) {
        return new Options().cpuBudget(cpuBudget);
    }

    public static Options ramBudget(Long ramBudget) {
        return new Options().ramBudget(ramBudget);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private ModelDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Long algorithm;
        private Long cpuBudget;
        private Long ramBudget;

        public Options algorithm(Long algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Options cpuBudget(Long cpuBudget) {
            this.cpuBudget = cpuBudget;
            return this;
        }

        public Options ramBudget(Long ramBudget) {
            this.ramBudget = ramBudget;
            return this;
        }

        private Options() {
        }
    }
}

