/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

public final class QuantizedMatMulWithBias<W extends TType>
extends RawOp {
    public static final String OP_NAME = "QuantizedMatMulWithBias";
    private Output<W> out;
    private Output<TFloat32> minOut;
    private Output<TFloat32> maxOut;

    public static <W extends TType, T extends TType, U extends TType, V extends TType> QuantizedMatMulWithBias<W> create(Scope scope, Operand<T> a, Operand<U> b, Operand<V> bias, Operand<TFloat32> minA, Operand<TFloat32> maxA, Operand<TFloat32> minB, Operand<TFloat32> maxB, DataType<W> Toutput, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minA.asOutput());
        opBuilder.addInput(maxA.asOutput());
        opBuilder.addInput(minB.asOutput());
        opBuilder.addInput(maxB.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("Toutput", Toutput);
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB != null) {
                    opBuilder.setAttr("transpose_b", opts.transposeB);
                }
                if (opts.inputQuantMode == null) continue;
                opBuilder.setAttr("input_quant_mode", opts.inputQuantMode);
            }
        }
        return new QuantizedMatMulWithBias<W>(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public static Options inputQuantMode(String inputQuantMode) {
        return new Options().inputQuantMode(inputQuantMode);
    }

    public Output<W> out() {
        return this.out;
    }

    public Output<TFloat32> minOut() {
        return this.minOut;
    }

    public Output<TFloat32> maxOut() {
        return this.maxOut;
    }

    private QuantizedMatMulWithBias(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.out = operation.output(outputIdx++);
        this.minOut = operation.output(outputIdx++);
        this.maxOut = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;
        private String inputQuantMode;

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public Options inputQuantMode(String inputQuantMode) {
            this.inputQuantMode = inputQuantMode;
            return this;
        }

        private Options() {
        }
    }
}

