/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class DecodeRaw<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "DecodeRaw";
    private Output<T> output;

    public static <T extends TType> DecodeRaw<T> create(Scope scope, Operand<TString> bytes, DataType<T> outType, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(bytes.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("out_type", outType);
        if (options != null) {
            for (Options opts : options) {
                if (opts.littleEndian == null) continue;
                opBuilder.setAttr("little_endian", opts.littleEndian);
            }
        }
        return new DecodeRaw<T>(opBuilder.build());
    }

    public static Options littleEndian(Boolean littleEndian) {
        return new Options().littleEndian(littleEndian);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private DecodeRaw(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean littleEndian;

        public Options littleEndian(Boolean littleEndian) {
            this.littleEndian = littleEndian;
            return this;
        }

        private Options() {
        }
    }
}

