/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class Skipgram
extends RawOp {
    public static final String OP_NAME = "Skipgram";
    private Output<TString> vocabWord;
    private Output<TInt32> vocabFreq;
    private Output<TInt64> wordsPerEpoch;
    private Output<TInt32> currentEpoch;
    private Output<TInt64> totalWordsProcessed;
    private Output<TInt32> examples;
    private Output<TInt32> labels;

    public static Skipgram create(Scope scope, String filename, Long batchSize, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("filename", filename);
        opBuilder.setAttr("batch_size", batchSize);
        if (options != null) {
            for (Options opts : options) {
                if (opts.windowSize != null) {
                    opBuilder.setAttr("window_size", opts.windowSize);
                }
                if (opts.minCount != null) {
                    opBuilder.setAttr("min_count", opts.minCount);
                }
                if (opts.subsample == null) continue;
                opBuilder.setAttr("subsample", opts.subsample.floatValue());
            }
        }
        return new Skipgram(opBuilder.build());
    }

    public static Options windowSize(Long windowSize) {
        return new Options().windowSize(windowSize);
    }

    public static Options minCount(Long minCount) {
        return new Options().minCount(minCount);
    }

    public static Options subsample(Float subsample) {
        return new Options().subsample(subsample);
    }

    public Output<TString> vocabWord() {
        return this.vocabWord;
    }

    public Output<TInt32> vocabFreq() {
        return this.vocabFreq;
    }

    public Output<TInt64> wordsPerEpoch() {
        return this.wordsPerEpoch;
    }

    public Output<TInt32> currentEpoch() {
        return this.currentEpoch;
    }

    public Output<TInt64> totalWordsProcessed() {
        return this.totalWordsProcessed;
    }

    public Output<TInt32> examples() {
        return this.examples;
    }

    public Output<TInt32> labels() {
        return this.labels;
    }

    private Skipgram(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.vocabWord = operation.output(outputIdx++);
        this.vocabFreq = operation.output(outputIdx++);
        this.wordsPerEpoch = operation.output(outputIdx++);
        this.currentEpoch = operation.output(outputIdx++);
        this.totalWordsProcessed = operation.output(outputIdx++);
        this.examples = operation.output(outputIdx++);
        this.labels = operation.output(outputIdx++);
    }

    public static class Options {
        private Long windowSize;
        private Long minCount;
        private Float subsample;

        public Options windowSize(Long windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Options minCount(Long minCount) {
            this.minCount = minCount;
            return this;
        }

        public Options subsample(Float subsample) {
            this.subsample = subsample;
            return this;
        }

        private Options() {
        }
    }
}

