/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.jni;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.pytorch.engine.PtNDArray;
import ai.djl.pytorch.engine.PtNDManager;
import ai.djl.pytorch.jni.PyTorchLibrary;
import ai.djl.util.NativeResource;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IValue
extends NativeResource<Long> {
    IValue(long handle) {
        super((Object)handle);
    }

    public String getType() {
        return PyTorchLibrary.LIB.iValueGetType((Long)this.getHandle());
    }

    public boolean isTensor() {
        return PyTorchLibrary.LIB.iValueIsTensor((Long)this.getHandle());
    }

    public boolean isBoolean() {
        return PyTorchLibrary.LIB.iValueIsBool((Long)this.getHandle());
    }

    public boolean isLong() {
        return PyTorchLibrary.LIB.iValueIsLong((Long)this.getHandle());
    }

    public boolean isDouble() {
        return PyTorchLibrary.LIB.iValueIsDouble((Long)this.getHandle());
    }

    public boolean isString() {
        return PyTorchLibrary.LIB.iValueIsString((Long)this.getHandle());
    }

    public boolean isBooleanList() {
        return PyTorchLibrary.LIB.iValueIsBoolList((Long)this.getHandle());
    }

    public boolean isLongList() {
        return PyTorchLibrary.LIB.iValueIsLongList((Long)this.getHandle());
    }

    public boolean isDoubleList() {
        return PyTorchLibrary.LIB.iValueIsDoubleList((Long)this.getHandle());
    }

    public boolean isTensorList() {
        return PyTorchLibrary.LIB.iValueIsTensorList((Long)this.getHandle());
    }

    public boolean isList() {
        return PyTorchLibrary.LIB.iValueIsList((Long)this.getHandle());
    }

    public boolean isMap() {
        return PyTorchLibrary.LIB.iValueIsMap((Long)this.getHandle());
    }

    public boolean isTuple() {
        return PyTorchLibrary.LIB.iValueIsTuple((Long)this.getHandle());
    }

    public static IValue from(PtNDArray array) {
        if (array.getDataType() == DataType.STRING) {
            Shape shape = array.getShape();
            String[] strs = array.toStringArray();
            if (shape.isScalar()) {
                return IValue.from(strs[0]);
            }
            IValue[] list = new IValue[strs.length];
            PtNDManager manager = array.getManager();
            for (int i = 0; i < strs.length; ++i) {
                IValue ivalue = IValue.from(strs[i]);
                manager.attachUncappedInternal(ivalue.getUid(), (AutoCloseable)((Object)ivalue));
                list[i] = ivalue;
            }
            return IValue.listFrom(list);
        }
        return new IValue(PyTorchLibrary.LIB.iValueFromTensor((Long)array.getHandle()));
    }

    public static IValue from(boolean value) {
        return new IValue(PyTorchLibrary.LIB.iValueFromBool(value));
    }

    public static IValue from(long value) {
        return new IValue(PyTorchLibrary.LIB.iValueFromLong(value));
    }

    public static IValue from(double value) {
        return new IValue(PyTorchLibrary.LIB.iValueFromDouble(value));
    }

    public static IValue from(String value) {
        return new IValue(PyTorchLibrary.LIB.iValueFromString(value));
    }

    public static IValue listFrom(boolean ... list) {
        return new IValue(PyTorchLibrary.LIB.iValueFromBoolList(list));
    }

    public static IValue listFrom(long ... list) {
        return new IValue(PyTorchLibrary.LIB.iValueFromLongList(list));
    }

    public static IValue listFrom(double ... list) {
        return new IValue(PyTorchLibrary.LIB.iValueFromDoubleList(list));
    }

    public static IValue listFrom(PtNDArray ... list) {
        long[] tensors = Arrays.stream(list).mapToLong(NativeResource::getHandle).toArray();
        return new IValue(PyTorchLibrary.LIB.iValueFromTensorList(tensors));
    }

    public static IValue listFrom(IValue ... list) {
        if (list.length == 0) {
            throw new IllegalArgumentException("Empty IValue list is not supported.");
        }
        long[] tensors = Arrays.stream(list).mapToLong(NativeResource::getHandle).toArray();
        return new IValue(PyTorchLibrary.LIB.iValueFromList(tensors));
    }

    public static IValue tupleFrom(IValue ... list) {
        long[] tensors = Arrays.stream(list).mapToLong(NativeResource::getHandle).toArray();
        return new IValue(PyTorchLibrary.LIB.iValueFromTuple(tensors));
    }

    public static IValue stringMapFrom(Map<String, PtNDArray> map) {
        String[] keys = new String[map.size()];
        long[] handles = new long[map.size()];
        int i = 0;
        for (Map.Entry<String, PtNDArray> entry : map.entrySet()) {
            keys[i] = entry.getKey();
            handles[i] = (Long)entry.getValue().getHandle();
            ++i;
        }
        return new IValue(PyTorchLibrary.LIB.iValueFromStringMap(keys, handles));
    }

    public static IValue stringIValueMapFrom(Map<String, IValue> map) {
        String[] keys = new String[map.size()];
        long[] handles = new long[map.size()];
        int i = 0;
        for (Map.Entry<String, IValue> entry : map.entrySet()) {
            keys[i] = entry.getKey();
            handles[i] = (Long)entry.getValue().getHandle();
            ++i;
        }
        return new IValue(PyTorchLibrary.LIB.iValueFromStringIValueMap(keys, handles));
    }

    public boolean toBoolean() {
        return PyTorchLibrary.LIB.iValueToBool((Long)this.getHandle());
    }

    public long toLong() {
        return PyTorchLibrary.LIB.iValueToLong((Long)this.getHandle());
    }

    public double toDouble() {
        return PyTorchLibrary.LIB.iValueToDouble((Long)this.getHandle());
    }

    public String toStringValue() {
        return PyTorchLibrary.LIB.iValueToString((Long)this.getHandle());
    }

    public boolean[] toBooleanArray() {
        return PyTorchLibrary.LIB.iValueToBoolList((Long)this.getHandle());
    }

    public long[] toLongArray() {
        return PyTorchLibrary.LIB.iValueToLongList((Long)this.getHandle());
    }

    public double[] toDoubleArray() {
        return PyTorchLibrary.LIB.iValueToDoubleList((Long)this.getHandle());
    }

    public PtNDArray toTensor(PtNDManager manager) {
        return new PtNDArray(manager, PyTorchLibrary.LIB.iValueToTensor((Long)this.getHandle()));
    }

    public PtNDArray[] toTensorArray(PtNDManager manager) {
        long[] handles = PyTorchLibrary.LIB.iValueToTensorList((Long)this.getHandle());
        PtNDArray[] ret = new PtNDArray[handles.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new PtNDArray(manager, handles[i]);
        }
        return ret;
    }

    public IValue[] toIValueArray() {
        long[] handles = PyTorchLibrary.LIB.iValueToIValueList((Long)this.getHandle());
        IValue[] ret = new IValue[handles.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new IValue(handles[i]);
        }
        return ret;
    }

    public Map<String, IValue> toIValueMap() {
        long[] handles = PyTorchLibrary.LIB.iValueToMap((Long)this.getHandle());
        ConcurrentHashMap<String, IValue> map = new ConcurrentHashMap<String, IValue>();
        for (int i = 0; i < handles.length; i += 2) {
            IValue key = new IValue(handles[i]);
            map.put(key.toStringValue(), new IValue(handles[i + 1]));
            key.close();
        }
        return map;
    }

    public IValue[] toIValueTuple() {
        long[] handles = PyTorchLibrary.LIB.iValueToIValueTuple((Long)this.getHandle());
        IValue[] ret = new IValue[handles.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new IValue(handles[i]);
        }
        return ret;
    }

    public NDList toNDList(PtNDManager manager) {
        if (this.isTensor()) {
            return new NDList(new NDArray[]{this.toTensor(manager)});
        }
        if (this.isTensorList()) {
            return new NDList((NDArray[])this.toTensorArray(manager));
        }
        if (this.isMap()) {
            NDList list = new NDList();
            Map<String, IValue> map = this.toIValueMap();
            for (Map.Entry<String, IValue> entry : map.entrySet()) {
                IValue iv = entry.getValue();
                if (!iv.isTensor()) {
                    throw new UnsupportedOperationException("Only one level of map is supported.");
                }
                PtNDArray value = entry.getValue().toTensor(manager);
                value.setName(entry.getKey());
                list.add((Object)value);
                iv.close();
            }
            return list;
        }
        if (this.isList()) {
            NDList list = new NDList();
            for (IValue ivalue : this.toIValueArray()) {
                list.addAll(ivalue.toNDList(manager));
                ivalue.close();
            }
            return list;
        }
        if (this.isTuple()) {
            NDList list = new NDList();
            for (IValue ivalue : this.toIValueTuple()) {
                list.addAll(ivalue.toNDList(manager));
                ivalue.close();
            }
            return list;
        }
        if (this.isString()) {
            return new NDList(new NDArray[]{manager.create(this.toStringValue())});
        }
        throw new UnsupportedOperationException("Unsupported IValue type.");
    }

    public void close() {
        Long pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            PyTorchLibrary.LIB.torchDeleteIValue(pointer);
        }
    }
}

