/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.onnxruntime.engine.OrtNDManager;
import ai.djl.onnxruntime.engine.OrtUtils;
import ai.onnxruntime.OnnxTensor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.UUID;

public class OrtNDArray
implements NDArray {
    private OrtNDManager manager;
    private OnnxTensor tensor;
    private Shape shape;
    private DataType dataType;
    private String name;
    private boolean isClosed;
    private String uid;

    OrtNDArray(OrtNDManager manager, OnnxTensor tensor) {
        this.manager = manager;
        this.tensor = tensor;
        this.uid = UUID.randomUUID().toString();
        manager.attach(this.uid, (AutoCloseable)((Object)this));
    }

    OnnxTensor getTensor() {
        return this.tensor;
    }

    public NDManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUid() {
        return this.uid;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = OrtUtils.toDataType(this.tensor.getInfo().type);
        }
        return this.dataType;
    }

    public Device getDevice() {
        return Device.cpu();
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = new Shape(this.tensor.getInfo().getShape());
        }
        return this.shape;
    }

    public SparseFormat getSparseFormat() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDManager attach(NDManager manager) {
        this.detach();
        OrtNDManager original = this.manager;
        this.manager = (OrtNDManager)manager;
        manager.attach(this.getUid(), (AutoCloseable)((Object)this));
        return original;
    }

    public void detach() {
        this.manager.detach(this.getUid());
        this.manager = OrtNDManager.getSystemManager();
    }

    public NDArray toDevice(Device device, boolean copy) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray toType(DataType dataType, boolean copy) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public void attachGradient() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public void attachGradient(SparseFormat sparseFormat) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray getGradient() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public boolean hasGradient() {
        return false;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer bb = this.tensor.getByteBuffer();
        bb.order(ByteOrder.nativeOrder());
        return bb;
    }

    public void set(Buffer data) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public void set(NDIndex index, NDArray value) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public void set(NDIndex index, Number value) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public void setScalar(NDIndex index, Number value) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray get(NDIndex index) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public void copyTo(NDArray array) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray booleanMask(NDArray index, int axis) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sequenceMask(NDArray sequenceLength, float value) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sequenceMask(NDArray sequenceLength) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray zerosLike() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray onesLike() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public boolean contentEquals(Number number) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public boolean contentEquals(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray eq(Number other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray eq(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray neq(Number other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray neq(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray gt(Number other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray gt(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray gte(Number other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray gte(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray lt(Number other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray lt(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray lte(Number other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray lte(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray add(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray add(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sub(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sub(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray mul(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray mul(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray div(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray div(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray mod(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray mod(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray pow(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray pow(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray addi(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray addi(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray subi(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray subi(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray muli(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray muli(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray divi(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray divi(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray modi(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray modi(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray powi(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray powi(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sign() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray signi() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray maximum(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray maximum(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray minimum(Number n) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray minimum(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray neg() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray negi() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray abs() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray square() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sqrt() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray cbrt() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray floor() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray ceil() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray round() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray trunc() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray exp() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray log() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray log10() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray log2() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sin() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray cos() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray tan() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray asin() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray acos() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray atan() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sinh() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray cosh() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray tanh() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray asinh() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray acosh() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray atanh() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray toDegrees() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray toRadians() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray max() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray max(int[] axes, boolean keepDims) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray min() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray min(int[] axes, boolean keepDims) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sum() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sum(int[] axes, boolean keepDims) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray prod() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray prod(int[] axes, boolean keepDims) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray mean() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray mean(int[] axes, boolean keepDims) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray trace(int offset, int axis1, int axis2) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDList split(long[] indices, int axis) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray flatten() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray reshape(Shape shape) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray expandDims(int axis) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray squeeze(int[] axes) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray logicalAnd(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray logicalOr(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray logicalXor(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray logicalNot() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray argSort(int axis, boolean ascending) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sort() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray sort(int axis) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray softmax(int axis) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray logSoftmax(int axis) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray cumSum() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray cumSum(int axis) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray isInfinite() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray isNaN() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray tile(long repeats) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray tile(int axis, long repeats) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray tile(long[] repeats) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray tile(Shape desiredShape) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray repeat(long repeats) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray repeat(int axis, long repeats) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray repeat(long[] repeats) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray repeat(Shape desiredShape) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray dot(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray matMul(NDArray other) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray clip(Number min, Number max) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray flip(int ... axes) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray transpose() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray transpose(int ... axes) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray broadcast(Shape shape) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray argMax() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray argMax(int axis) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray argMin() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray argMin(int axis) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray percentile(Number percentile) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray percentile(Number percentile, int[] axes) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray median() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray median(int[] axes) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray toDense() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray toSparse(SparseFormat fmt) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray nonzero() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArrayEx getNDArrayInternal() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public String toString() {
        if (this.isClosed) {
            return "This array is already closed";
        }
        return "ND: " + this.getShape() + ' ' + this.getDevice() + ' ' + this.getDataType() + '\n' + Arrays.toString(this.toArray());
    }

    public void close() {
        this.tensor.close();
        this.isClosed = true;
    }
}

