/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.ndarray.NDManager;
import ai.djl.onnxruntime.engine.OrtModel;
import ai.djl.onnxruntime.engine.OrtNDManager;
import ai.djl.training.GradientCollector;
import ai.onnxruntime.OrtEnvironment;

public final class OrtEngine
extends Engine {
    public static final String ENGINE_NAME = "OnnxRuntime";
    private Engine secondaryEngine;
    private OrtEnvironment env = OrtEnvironment.getEnvironment();

    private OrtEngine() {
    }

    static Engine newInstance() {
        return new OrtEngine();
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    Engine getSecondEngine() {
        if (this.secondaryEngine == null) {
            for (Engine availableEngine : Engine.getAllEngines()) {
                if (ENGINE_NAME.equals(availableEngine.getEngineName())) continue;
                this.secondaryEngine = availableEngine;
                break;
            }
        }
        return this.secondaryEngine;
    }

    public String getVersion() {
        return "1.3.0";
    }

    public boolean hasCapability(String capability) {
        return false;
    }

    public Model newModel(String name, Device device) {
        return new OrtModel(name, this.newBaseManager(device), this.env);
    }

    public NDManager newBaseManager() {
        return this.newBaseManager(null);
    }

    public NDManager newBaseManager(Device device) {
        if (this.getSecondEngine() != null) {
            return this.secondaryEngine.newBaseManager(device);
        }
        return OrtNDManager.getSystemManager().newSubManager(device);
    }

    public GradientCollector newGradientCollector() {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public void setRandomSeed(int seed) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }
}

