/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.engine.EngineException;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrayAdapter;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.onnxruntime.engine.OrtNDManager;
import ai.djl.onnxruntime.engine.OrtUtils;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class OrtNDArray
extends NDArrayAdapter {
    private AtomicReference<OnnxTensor> tensor;

    OrtNDArray(OrtNDManager manager, NDManager alternativeManager, OnnxTensor tensor) {
        super((NDManager)manager, alternativeManager, null, null, UUID.randomUUID().toString());
        this.tensor = new AtomicReference<OnnxTensor>(tensor);
        manager.attachInternal(this.uid, new AutoCloseable[]{this});
    }

    public OnnxTensor getTensor() {
        return this.tensor.get();
    }

    public DataType getDataType() {
        if (this.isClosed) {
            throw new IllegalStateException("Native resource has been release already.");
        }
        if (this.dataType == null) {
            this.dataType = OrtUtils.toDataType(this.tensor.get().getInfo().type);
        }
        return this.dataType;
    }

    public Shape getShape() {
        if (this.isClosed) {
            throw new IllegalStateException("Native resource has been release already.");
        }
        if (this.shape == null) {
            this.shape = new Shape(this.tensor.get().getInfo().getShape());
        }
        return this.shape;
    }

    public void intern(NDArray replaced) {
        OrtNDArray arr = (OrtNDArray)replaced;
        OnnxTensor oldHandle = this.tensor.getAndSet(arr.tensor.getAndSet(null));
        if (oldHandle != null) {
            oldHandle.close();
        }
        replaced.close();
    }

    public void detach() {
        this.manager.detachInternal(this.getUid());
        this.manager = OrtNDManager.getSystemManager();
    }

    public String[] toStringArray(Charset charset) {
        if (this.isClosed) {
            throw new IllegalStateException("Native resource has been release already.");
        }
        try {
            Object obj = this.tensor.get().getValue();
            if (obj instanceof String) {
                return new String[]{(String)obj};
            }
            if (obj instanceof String[]) {
                return (String[])obj;
            }
            if (obj instanceof String[][]) {
                String[][] data = (String[][])obj;
                if (data.length == 0) {
                    return new String[0];
                }
                String[] ret = new String[data.length * data[0].length];
                for (int i = 0; i < data.length; ++i) {
                    System.arraycopy(data[i], 0, ret, i * data.length, data[i].length);
                }
                return ret;
            }
            throw new UnsupportedOperationException("Unsupported Data type: " + obj.getClass());
        }
        catch (OrtException e) {
            throw new EngineException((Throwable)e);
        }
    }

    public ByteBuffer toByteBuffer(boolean tryDirect) {
        if (this.getDataType() == DataType.STRING) {
            throw new IllegalArgumentException("Please use toStringArray() for String NDArray.");
        }
        return this.tensor.get().getByteBuffer().order(ByteOrder.nativeOrder());
    }

    public void close() {
        OnnxTensor ortTensor = this.tensor.getAndSet(null);
        if (ortTensor != null) {
            ortTensor.close();
        }
        super.close();
    }
}

