/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo.cv.actionrecognition;

import ai.djl.modality.Classifications;
import ai.djl.modality.cv.ImageClassificationTranslator;
import ai.djl.modality.cv.transform.Normalize;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.repository.Anchor;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import java.awt.image.BufferedImage;
import java.util.Map;

public class ActionRecognitionModelLoader
extends BaseModelLoader<BufferedImage, Classifications> {
    private static final Anchor BASE_ANCHOR = MRL.Model.CV.ACTION_RECOGNITION;
    private static final String GROUP_ID = "ai.djl.mxnet";
    private static final String ARTIFACT_ID = "action_recognition";
    private static final String VERSION = "0.0.1";

    public ActionRecognitionModelLoader(Repository repository) {
        super(repository, new MRL(BASE_ANCHOR, GROUP_ID, ARTIFACT_ID), VERSION);
    }

    public Translator<BufferedImage, Classifications> getTranslator(Artifact artifact) {
        Map arguments = artifact.getArguments();
        int width = arguments.getOrDefault("width", 299.0).intValue();
        int height = arguments.getOrDefault("height", 299.0).intValue();
        Pipeline pipeline = new Pipeline();
        pipeline.add((Transform)new Resize(width, height)).add((Transform)new ToTensor()).add((Transform)new Normalize(new float[]{0.485f, 0.456f, 0.406f}, new float[]{0.229f, 0.224f, 0.225f}));
        return ((ImageClassificationTranslator.Builder)new ImageClassificationTranslator.Builder().setPipeline(pipeline)).setSynsetArtifactName("classes.txt").build();
    }
}

