/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import ai.djl.mxnet.jna.MxnetLibrary;
import ai.djl.util.Utils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "mxnet";
    private static final Pattern PATH_PATTERN = Pattern.compile("\\s*'(.+)',");

    private LibUtils() {
    }

    public static MxnetLibrary loadLibrary() {
        String libName = LibUtils.getLibName();
        logger.debug("Loading mxnet library from: {}", (Object)libName);
        return (MxnetLibrary)Native.load((String)libName, MxnetLibrary.class);
    }

    public static String getLibName() {
        String libName = LibUtils.findOverrideLibrary();
        if (libName == null && (libName = LibUtils.findLibraryInClasspath()) == null && (libName = LibUtils.searchPythonPath("python3 -m site")) == null && (libName = LibUtils.searchPythonPath("python -m site")) == null) {
            libName = LIB_NAME;
        }
        return libName;
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = System.getenv("MXNET_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static synchronized String findLibraryInClasspath() {
        ArrayList<URL> urls;
        try {
            urls = Collections.list(Thread.currentThread().getContextClassLoader().getResources("native/lib/mxnet.properties"));
        }
        catch (IOException e) {
            return null;
        }
        if (urls.isEmpty()) {
            return null;
        }
        ai.djl.util.Platform systemPlatform = ai.djl.util.Platform.fromSystem();
        try {
            ai.djl.util.Platform matching = null;
            ai.djl.util.Platform placeholder = null;
            for (URL url : urls) {
                ai.djl.util.Platform platform = ai.djl.util.Platform.fromUrl((URL)url);
                if (platform.isPlaceholder()) {
                    placeholder = platform;
                    continue;
                }
                if (!platform.matches(systemPlatform)) continue;
                matching = platform;
                break;
            }
            if (matching != null) {
                return LibUtils.loadLibraryFromClasspath(matching);
            }
            if (placeholder != null) {
                try {
                    return LibUtils.downloadMxnet(placeholder);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to download MXNet native library", e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read MXNet native library jar properties", e);
        }
        throw new IllegalStateException("Your MXNet native library jar does not match your operating system. Make sure that the Maven Dependency Classifier matches your system type.");
    }

    private static String loadLibraryFromClasspath(ai.djl.util.Platform platform) {
        String string;
        block21: {
            Path tmp = null;
            try {
                String userHome = System.getProperty("user.home");
                String libName = System.mapLibraryName(LIB_NAME);
                Path dir = Paths.get(userHome, ".mxnet/cache/" + platform.getVersion() + platform.getClassifier());
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = path.toAbsolutePath().toString();
                    return string2;
                }
                tmp = Paths.get(userHome, ".mxnet/cache/tmp");
                Files.createDirectories(tmp, new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "/native/lib/" + file;
                    try (InputStream is = LibUtils.class.getResourceAsStream(libPath);){
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.deleteQuietly((Path)dir);
                Files.move(tmp, dir, new CopyOption[0]);
                tmp = null;
                string = path.toAbsolutePath().toString();
                if (tmp == null) break block21;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract MXNet native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        List<String> mappedLibNames = Platform.isMac() ? Arrays.asList("libmxnet.dylib", "libmxnet.jnilib", "libmxnet.so") : Collections.singletonList(System.mapLibraryName(LIB_NAME));
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            for (String name : mappedLibNames) {
                if (p.isFile() && p.getName().endsWith(name)) {
                    return p.getAbsolutePath();
                }
                File file = new File(path, name);
                if (!file.exists() || !file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String searchPythonPath(String cmd) {
        String libName = Platform.isMac() ? "libmxnet.so" : System.mapLibraryName(LIB_NAME);
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                File file;
                File dir;
                String line;
                Matcher m;
                do {
                    if ((line = reader.readLine()) == null) return null;
                } while (!(m = PATH_PATTERN.matcher(line)).matches() || !(dir = new File(m.group(1))).isDirectory() || !(file = new File(dir, "mxnet/" + libName)).exists());
                String string = file.getAbsolutePath();
                return string;
            }
        }
        catch (IOException e) {
            if (!logger.isTraceEnabled()) return null;
            logger.trace("Failed execute cmd: " + cmd, (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static String downloadMxnet(ai.djl.util.Platform platform) throws IOException {
        String version = platform.getVersion();
        String flavor = platform.getFlavor();
        if (flavor.isEmpty()) {
            flavor = "mkl";
        } else if (!flavor.endsWith("mkl")) {
            flavor = flavor + "mkl";
        }
        String classifier = platform.getClassifier();
        String cudaArch = platform.getCudaArch();
        String os = platform.getOsPrefix();
        String userHome = System.getProperty("user.home");
        String libName = System.mapLibraryName(LIB_NAME);
        Path dir = Paths.get(userHome, ".mxnet/cache/" + version + flavor + '-' + classifier);
        Path path = dir.resolve(libName);
        if (Files.exists(path, new LinkOption[0])) {
            return path.toAbsolutePath().toString();
        }
        Path tmp = Paths.get(userHome, ".mxnet/cache/tmp");
        Files.createDirectories(tmp, new FileAttribute[0]);
        String[] versions = version.split("-");
        String link = "https://djl-ai.s3.amazonaws.com/publish/mxnet-" + versions[0];
        try {
            String string;
            try (InputStream is = new URL(link + "/files.txt").openStream();){
                List lines = Utils.readLines((InputStream)is);
                if (cudaArch != null) {
                    if ("win".equals(os)) {
                        if (!lines.contains(os + '/' + flavor + "/mxnet_" + cudaArch + ".dll.gz")) {
                            logger.warn("No matching cuda flavor for {} found: {}/sm_{}.", new Object[]{os, flavor, cudaArch});
                            flavor = "mkl";
                        }
                    } else if ("linux".equals(os)) {
                        if (!lines.contains(os + '/' + flavor + "/libmxnet.so.gz")) {
                            logger.warn("No matching cuda flavor for {} found: {}/sm_{}.", new Object[]{os, flavor, cudaArch});
                            flavor = "mkl";
                        }
                    } else {
                        throw new AssertionError((Object)("Unsupported GPU operating system: " + os));
                    }
                    if ("mkl".equals(flavor) && Files.exists(path = (dir = Paths.get(userHome, ".mxnet/cache/" + version + flavor + '-' + classifier)).resolve(libName), new LinkOption[0])) {
                        String string2 = path.toAbsolutePath().toString();
                        return string2;
                    }
                }
                for (String line : lines) {
                    if (!line.startsWith(os + "/common/") && !line.startsWith(os + '/' + flavor + '/')) continue;
                    URL url = new URL(link + '/' + line);
                    String fileName = line.substring(line.lastIndexOf(47) + 1, line.length() - 3);
                    if ("win".equals(os)) {
                        if ("libmxnet.dll".equals(fileName)) {
                            fileName = "mxnet.dll";
                        } else if ("libcumxnet.dll".equals(fileName)) {
                            fileName = "mxnet.dll";
                        } else if (fileName.startsWith("mxnet_") && !("mxnet_" + cudaArch + ".dll").equals(fileName)) continue;
                    }
                    GZIPInputStream fis = new GZIPInputStream(url.openStream());
                    Throwable throwable = null;
                    try {
                        Files.copy(fis, tmp.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)fis).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)fis).close();
                    }
                }
                Utils.deleteQuietly((Path)dir);
                Files.move(tmp, dir, new CopyOption[0]);
                tmp = null;
                string = path.toAbsolutePath().toString();
            }
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tmp != null) {
                Utils.deleteQuietly((Path)tmp);
            }
        }
    }
}

