/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import ai.djl.mxnet.jna.NativeString;
import ai.djl.mxnet.jna.ObjectPool;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

final class StringArray
extends Memory {
    private static final Charset ENCODING = Native.DEFAULT_CHARSET;
    private static final ObjectPool<StringArray> POOL = new ObjectPool(null, null);
    private List<NativeString> natives = new ArrayList<NativeString>();
    private int length;

    private StringArray(String[] strings) {
        super((long)((strings.length + 1) * Native.POINTER_SIZE));
        this.length = strings.length;
        this.setPointers(strings);
    }

    private void setPointers(String[] strings) {
        for (NativeString ns : this.natives) {
            ns.recycle();
        }
        this.natives.clear();
        for (int i = 0; i < strings.length; ++i) {
            Pointer p = null;
            if (strings[i] != null) {
                NativeString ns = NativeString.of(strings[i], ENCODING);
                this.natives.add(ns);
                p = ns.getPointer();
            }
            this.setPointer(Native.POINTER_SIZE * i, p);
        }
        this.setPointer(Native.POINTER_SIZE * strings.length, null);
    }

    public static StringArray of(String[] strings) {
        StringArray array = POOL.acquire();
        if (array != null && array.length >= strings.length) {
            array.setPointers(strings);
            return array;
        }
        return new StringArray(strings);
    }

    public void recycle() {
        POOL.recycle(this);
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

