/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.engine;

import ai.djl.ndarray.types.DataType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MxDataType {
    private static Map<DataType, String> toMx = MxDataType.createMapToMx();
    private static Map<String, DataType> fromMx = MxDataType.createMapFromMx();

    private MxDataType() {
    }

    private static Map<DataType, String> createMapToMx() {
        ConcurrentHashMap<DataType, String> map = new ConcurrentHashMap<DataType, String>();
        map.put(DataType.FLOAT32, "float32");
        map.put(DataType.FLOAT64, "float64");
        map.put(DataType.INT32, "int32");
        map.put(DataType.INT64, "int64");
        map.put(DataType.UINT8, "uint8");
        return map;
    }

    private static Map<String, DataType> createMapFromMx() {
        ConcurrentHashMap<String, DataType> map = new ConcurrentHashMap<String, DataType>();
        map.put("float32", DataType.FLOAT32);
        map.put("float64", DataType.FLOAT64);
        map.put("int32", DataType.INT32);
        map.put("int64", DataType.INT64);
        map.put("uint8", DataType.UINT8);
        return map;
    }

    public static DataType fromMx(String mxType) {
        return fromMx.get(mxType);
    }

    public static String toMx(DataType jType) {
        return toMx.get(jType);
    }
}

