/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.engine;

import ai.djl.Device;
import ai.djl.mxnet.engine.GradReq;
import ai.djl.mxnet.engine.MxNDArrayEx;
import ai.djl.mxnet.engine.MxNDManager;
import ai.djl.mxnet.engine.MxOpParams;
import ai.djl.mxnet.jna.JnaUtils;
import ai.djl.ndarray.BaseNDManager;
import ai.djl.ndarray.LazyNDArray;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.NDResource;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.util.NativeResource;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.stream.IntStream;

public class MxNDArray
extends NativeResource<Pointer>
implements LazyNDArray {
    private String name;
    private Device device;
    private SparseFormat sparseFormat;
    private DataType dataType;
    private Shape shape;
    private Boolean hasGradient;
    protected MxNDManager manager;
    private MxNDArrayEx mxNDArrayEx;

    MxNDArray(MxNDManager manager, Pointer handle, Device device, Shape shape, DataType dataType, boolean hasGradient) {
        this(manager, handle);
        this.device = device;
        if (Arrays.stream(shape.getShape()).anyMatch(s -> s < 0L)) {
            throw new IllegalArgumentException("The shape must be >= 0");
        }
        this.shape = shape;
        this.dataType = dataType;
        this.hasGradient = hasGradient;
    }

    MxNDArray(MxNDManager manager, Pointer handle) {
        super((Object)handle);
        this.manager = manager;
        this.mxNDArrayEx = new MxNDArrayEx(this);
        manager.attachInternal(this.getUid(), (AutoCloseable)((Object)this));
    }

    MxNDArray(MxNDManager manager, Pointer handle, SparseFormat fmt) {
        this(manager, handle);
        this.sparseFormat = fmt;
    }

    public MxNDManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = JnaUtils.getDataType((Pointer)this.getHandle());
        }
        return this.dataType;
    }

    public Device getDevice() {
        if (this.device == null) {
            this.device = JnaUtils.getDevice((Pointer)this.getHandle());
        }
        return this.device;
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = JnaUtils.getShape((Pointer)this.getHandle());
        }
        return this.shape;
    }

    public SparseFormat getSparseFormat() {
        if (this.sparseFormat == null) {
            this.sparseFormat = JnaUtils.getStorageType((Pointer)this.getHandle());
        }
        return this.sparseFormat;
    }

    public void attach(NDManager manager) {
        this.detach();
        this.manager = (MxNDManager)manager;
        manager.attachInternal(this.getUid(), (AutoCloseable)((Object)this));
    }

    public void tempAttach(NDManager manager) {
        MxNDManager original = this.manager;
        this.detach();
        this.manager = (MxNDManager)manager;
        manager.tempAttachInternal((NDManager)original, this.getUid(), (NDResource)this);
    }

    public void detach() {
        this.manager.detachInternal(this.getUid());
        this.manager = MxNDManager.getSystemManager();
    }

    private NDArray duplicate(NDManager manager, Shape shape, DataType dataType, Device device, String name) {
        NDArray array = manager.create(shape, dataType, device);
        array.setName(name);
        this.copyTo(array);
        return array;
    }

    public NDArray toDevice(Device device, boolean copy) {
        if (device.equals((Object)this.getDevice()) && !copy) {
            return this;
        }
        return this.duplicate((NDManager)this.getManager(), this.getShape(), this.getDataType(), device, this.getName());
    }

    public NDArray toType(DataType dataType, boolean copy) {
        if (dataType.equals((Object)this.getDataType()) && !copy) {
            return this;
        }
        return this.duplicate((NDManager)this.getManager(), this.getShape(), dataType, this.getDevice(), this.getName());
    }

    public void backward(boolean retainGraph) {
        JnaUtils.autogradBackward(new NDList(new NDArray[]{this}), retainGraph ? 1 : 0);
    }

    public void setRequiresGradient(boolean requiresGrad) {
        if (requiresGrad && this.hasGradient() || !requiresGrad && !this.hasGradient()) {
            return;
        }
        MxNDArray grad = this.hasGradient() ? (MxNDArray)this.getGradient() : this.createGradient(this.getSparseFormat());
        int gradReqValue = requiresGrad ? GradReq.WRITE.getValue() : GradReq.NULL.getValue();
        IntBuffer gradReqBuffer = IntBuffer.allocate(1);
        gradReqBuffer.put(0, gradReqValue);
        JnaUtils.autogradMarkVariables(1, (Pointer)this.getHandle(), gradReqBuffer, (Pointer)grad.getHandle());
        this.hasGradient = requiresGrad;
        grad.close();
    }

    private MxNDArray createGradient(SparseFormat format) {
        try (MxNDArray zeros = (MxNDArray)this.manager.zeros(this.getShape(), this.getDataType(), this.getDevice());){
            MxNDArray mxNDArray = (MxNDArray)zeros.toSparse(format);
            return mxNDArray;
        }
    }

    public NDArray getGradient() {
        if (!this.hasGradient()) {
            throw new IllegalStateException("No gradient attached to this NDArray, please call array.setRequiresGradient() on your NDArray or block.setInitializer() on your Block");
        }
        Pointer pointer = JnaUtils.getGradient((Pointer)this.getHandle());
        return this.manager.create(pointer);
    }

    public boolean hasGradient() {
        if (this.hasGradient == null) {
            Pointer pointer = JnaUtils.getGradient((Pointer)this.getHandle());
            this.hasGradient = pointer != null;
        }
        return this.hasGradient;
    }

    public NDArray stopGradient() {
        Pointer pointer = JnaUtils.detachGradient((Pointer)this.getHandle());
        return this.manager.create(pointer);
    }

    public String[] toStringArray(Charset charset) {
        throw new UnsupportedOperationException("String NDArray is not supported!");
    }

    public ByteBuffer toByteBuffer() {
        if (this.getSparseFormat() != SparseFormat.DENSE) {
            throw new IllegalStateException("Require Dense NDArray, actual " + this.getSparseFormat());
        }
        Shape sh = this.getShape();
        DataType dType = this.getDataType();
        long product = sh.size();
        long len = (long)dType.getNumOfBytes() * product;
        ByteBuffer bb = this.manager.allocateDirect(Math.toIntExact(len));
        Pointer pointer = Native.getDirectBufferPointer((Buffer)bb);
        JnaUtils.syncCopyToCPU((Pointer)this.getHandle(), pointer, Math.toIntExact(product));
        return bb;
    }

    public void set(Buffer data) {
        int size = Math.toIntExact(this.size());
        DataType type = this.getDataType();
        BaseNDManager.validateBufferSize((Buffer)data, (DataType)type, (int)size);
        if (data.isDirect()) {
            JnaUtils.syncCopyFromCPU((Pointer)this.getHandle(), data, size);
            return;
        }
        ByteBuffer buf = this.manager.allocateDirect(size * type.getNumOfBytes());
        BaseNDManager.copyBuffer((Buffer)data, (ByteBuffer)buf);
        JnaUtils.syncCopyFromCPU((Pointer)this.getHandle(), buf, size);
    }

    public void copyTo(NDArray ndArray) {
        if (!(ndArray instanceof MxNDArray)) {
            throw new IllegalArgumentException("Only MxNDArray is supported.");
        }
        Shape inShape = this.getShape();
        Shape destShape = ndArray.getShape();
        if (!Arrays.equals(inShape.getShape(), destShape.getShape())) {
            throw new IllegalArgumentException("shape are diff. Required: " + destShape + ", Actual " + inShape);
        }
        this.manager.invoke("_npi_copyto", new NDArray[]{this}, new NDArray[]{ndArray}, null);
    }

    /*
     * Exception decompiling
     */
    public NDArray booleanMask(NDArray index, int axis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray sequenceMask(NDArray sequenceLength, float value) {
        if (this.getShape().dimension() < 2 || this.getShape().isScalar() || this.getShape().hasZeroDimension()) {
            throw new IllegalArgumentException("sequenceMask is not supported for NDArray with less than 2 dimensions");
        }
        Shape expectedSequenceLengthShape = new Shape(new long[]{this.getShape().get(0)});
        if (!sequenceLength.getShape().equals((Object)expectedSequenceLengthShape)) {
            throw new IllegalArgumentException("SequenceLength must be of shape [batchSize]");
        }
        MxOpParams params = new MxOpParams();
        params.add("value", Float.valueOf(value));
        params.add("use_sequence_length", true);
        params.add("axis", 1);
        return this.manager.invoke("_npx_sequence_mask", new NDList(new NDArray[]{this, sequenceLength}), params).head();
    }

    public NDArray sequenceMask(NDArray sequenceLength) {
        return this.sequenceMask(sequenceLength, 0.0f);
    }

    public boolean contentEquals(Number number) {
        if (number == null) {
            return false;
        }
        try (NDArray result = this.eq(number);){
            boolean bl = result.all().getBoolean(new long[0]);
            return bl;
        }
    }

    public boolean contentEquals(NDArray other) {
        if (other == null || !this.shapeEquals(other)) {
            return false;
        }
        if (this.getDataType() != other.getDataType()) {
            return false;
        }
        try (NDArray result = this.eq(other).toType(DataType.INT32, false);){
            boolean bl = result.all().getBoolean(new long[0]);
            return bl;
        }
    }

    public NDArray eq(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        return this.manager.invoke("_npi_equal_scalar", (NDArray)this, params);
    }

    public NDArray eq(NDArray other) {
        return this.manager.invoke("_npi_equal", new NDArray[]{this, other}, null);
    }

    public NDArray neq(Number other) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", other.toString());
        return this.manager.invoke("_npi_not_equal_scalar", (NDArray)this, params);
    }

    public NDArray neq(NDArray other) {
        return this.manager.invoke("_npi_not_equal", new NDArray[]{this, other}, null);
    }

    public NDArray gt(Number other) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", other.toString());
        return this.manager.invoke("_npi_greater_scalar", (NDArray)this, params);
    }

    public NDArray gt(NDArray other) {
        return this.manager.invoke("_npi_greater", new NDArray[]{this, other}, null);
    }

    public NDArray gte(Number other) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", other.toString());
        return this.manager.invoke("_npi_greater_equal_scalar", (NDArray)this, params);
    }

    public NDArray gte(NDArray other) {
        return this.manager.invoke("_npi_greater_equal", new NDArray[]{this, other}, null);
    }

    public NDArray lt(Number other) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", other.toString());
        return this.manager.invoke("_npi_less_scalar", (NDArray)this, params);
    }

    public NDArray lt(NDArray other) {
        return this.manager.invoke("_npi_less", new NDArray[]{this, other}, null);
    }

    public NDArray lte(Number other) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", other.toString());
        return this.manager.invoke("_npi_less_equal_scalar", (NDArray)this, params);
    }

    public NDArray lte(NDArray other) {
        return this.manager.invoke("_npi_less_equal", new NDArray[]{this, other}, null);
    }

    public NDArray add(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        return this.manager.invoke("_npi_add_scalar", (NDArray)this, params);
    }

    public NDArray add(NDArray other) {
        return this.manager.invoke("_npi_add", new NDArray[]{this, other}, null);
    }

    public NDArray sub(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        return this.manager.invoke("_npi_subtract_scalar", (NDArray)this, params);
    }

    public NDArray sub(NDArray other) {
        return this.manager.invoke("_npi_subtract", new NDArray[]{this, other}, null);
    }

    public NDArray mul(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        return this.manager.invoke("_npi_multiply_scalar", (NDArray)this, params);
    }

    public NDArray mul(NDArray other) {
        return this.manager.invoke("_npi_multiply", new NDArray[]{this, other}, null);
    }

    public NDArray toSparse(SparseFormat fmt) {
        if (fmt != SparseFormat.DENSE && fmt != SparseFormat.CSR && fmt != SparseFormat.ROW_SPARSE) {
            throw new UnsupportedOperationException(fmt + " is not supported");
        }
        if (fmt == this.getSparseFormat()) {
            return this.duplicate();
        }
        return this.castStorage(fmt);
    }

    private NDArray castStorage(SparseFormat fmt) {
        MxOpParams params = new MxOpParams();
        params.setParam("stype", fmt.getType());
        return this.manager.invoke("cast_storage", (NDArray)this, params);
    }

    public NDArray div(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        return this.manager.invoke("_npi_true_divide_scalar", (NDArray)this, params);
    }

    public NDArray div(NDArray other) {
        return this.manager.invoke("_npi_true_divide", new NDArray[]{this, other}, null);
    }

    public NDArray mod(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        return this.manager.invoke("_npi_mod_scalar", (NDArray)this, params);
    }

    public NDArray mod(NDArray other) {
        return this.manager.invoke("_npi_mod", new NDArray[]{this, other}, null);
    }

    public NDArray pow(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        return this.manager.invoke("_npi_power_scalar", (NDArray)this, params);
    }

    public NDArray pow(NDArray other) {
        return this.manager.invoke("_npi_power", new NDArray[]{this, other}, null);
    }

    public NDArray addi(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        this.manager.invoke("_npi_add_scalar", new NDArray[]{this}, new NDArray[]{this}, params);
        return this;
    }

    public NDArray addi(NDArray other) {
        this.manager.invoke("_npi_add", new NDArray[]{this, other}, new NDArray[]{this}, null);
        return this;
    }

    public NDArray subi(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        this.manager.invoke("_npi_subtract_scalar", new NDArray[]{this}, new NDArray[]{this}, params);
        return this;
    }

    public NDArray subi(NDArray other) {
        this.manager.invoke("_npi_subtract", new NDArray[]{this, other}, new NDArray[]{this}, null);
        return this;
    }

    public NDArray muli(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        this.manager.invoke("_npi_multiply_scalar", new NDArray[]{this}, new NDArray[]{this}, params);
        return this;
    }

    public NDArray muli(NDArray other) {
        this.manager.invoke("_npi_multiply", new NDArray[]{this, other}, new NDArray[]{this}, null);
        return this;
    }

    public NDArray divi(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        this.manager.invoke("_npi_true_divide_scalar", new NDArray[]{this}, new NDArray[]{this}, params);
        return this;
    }

    public NDArray divi(NDArray other) {
        this.manager.invoke("_npi_true_divide", new NDArray[]{this, other}, new NDArray[]{this}, null);
        return this;
    }

    public NDArray modi(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        this.manager.invoke("_npi_mod_scalar", new NDArray[]{this}, new NDArray[]{this}, params);
        return this;
    }

    public NDArray modi(NDArray other) {
        this.manager.invoke("_npi_mod", new NDArray[]{this, other}, new NDArray[]{this}, null);
        return this;
    }

    public NDArray powi(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        this.manager.invoke("_npi_power_scalar", new NDArray[]{this}, new NDArray[]{this}, params);
        return this;
    }

    public NDArray powi(NDArray other) {
        this.manager.invoke("_npi_power", new NDArray[]{this, other}, new NDArray[]{this}, null);
        return this;
    }

    public NDArray neg() {
        return this.manager.invoke("_npi_negative", (NDArray)this, null);
    }

    public NDArray negi() {
        this.manager.invoke("_npi_negative", new NDArray[]{this}, new NDArray[]{this}, null);
        return this;
    }

    public NDArray sign() {
        return this.manager.invoke("_npi_sign", (NDArray)this, null);
    }

    public NDArray signi() {
        this.manager.invoke("_npi_sign", new NDArray[]{this}, new NDArray[]{this}, null);
        return this;
    }

    public NDArray abs() {
        return this.manager.invoke("_npi_absolute", (NDArray)this, null);
    }

    public NDArray square() {
        return this.manager.invoke("_npi_square", (NDArray)this, null);
    }

    public NDArray sqrt() {
        return this.manager.invoke("_npi_sqrt", (NDArray)this, null);
    }

    public NDArray cbrt() {
        return this.manager.invoke("_npi_cbrt", (NDArray)this, null);
    }

    public NDArray floor() {
        return this.manager.invoke("_npi_floor", (NDArray)this, null);
    }

    public NDArray ceil() {
        return this.manager.invoke("_npi_ceil", (NDArray)this, null);
    }

    public NDArray round() {
        return this.manager.invoke("round", (NDArray)this, null);
    }

    public NDArray trunc() {
        return this.manager.invoke("_npi_trunc", (NDArray)this, null);
    }

    public NDArray exp() {
        return this.manager.invoke("_npi_exp", (NDArray)this, null);
    }

    public NDArray log() {
        return this.manager.invoke("_npi_log", (NDArray)this, null);
    }

    public NDArray log10() {
        return this.manager.invoke("_npi_log10", (NDArray)this, null);
    }

    public NDArray log2() {
        return this.manager.invoke("_npi_log2", (NDArray)this, null);
    }

    public NDArray sin() {
        return this.manager.invoke("_npi_sin", (NDArray)this, null);
    }

    public NDArray cos() {
        return this.manager.invoke("_npi_cos", (NDArray)this, null);
    }

    public NDArray tan() {
        return this.manager.invoke("_npi_tan", (NDArray)this, null);
    }

    public NDArray asin() {
        return this.manager.invoke("_npi_arcsin", (NDArray)this, null);
    }

    public NDArray acos() {
        return this.manager.invoke("_npi_arccos", (NDArray)this, null);
    }

    public NDArray atan() {
        return this.manager.invoke("_npi_arctan", (NDArray)this, null);
    }

    public NDArray sinh() {
        return this.manager.invoke("_npi_sinh", (NDArray)this, null);
    }

    public NDArray cosh() {
        return this.manager.invoke("_npi_cosh", (NDArray)this, null);
    }

    public NDArray tanh() {
        return this.manager.invoke("_npi_tanh", (NDArray)this, null);
    }

    public NDArray asinh() {
        return this.manager.invoke("_npi_arcsinh", (NDArray)this, null);
    }

    public NDArray acosh() {
        return this.manager.invoke("_npi_arccosh", (NDArray)this, null);
    }

    public NDArray atanh() {
        return this.manager.invoke("_npi_arctanh", (NDArray)this, null);
    }

    public NDArray toDegrees() {
        return this.manager.invoke("_npi_degrees", (NDArray)this, null);
    }

    public NDArray toRadians() {
        return this.manager.invoke("_npi_radians", (NDArray)this, null);
    }

    public NDArray maximum(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        return this.manager.invoke("_npi_maximum_scalar", (NDArray)this, params);
    }

    public NDArray maximum(NDArray other) {
        return this.manager.invoke("_npi_maximum", new NDArray[]{this, other}, null);
    }

    public NDArray minimum(Number n) {
        MxOpParams params = new MxOpParams();
        params.add("scalar", n.toString());
        return this.manager.invoke("_npi_minimum_scalar", (NDArray)this, params);
    }

    public NDArray minimum(NDArray other) {
        return this.manager.invoke("_npi_minimum", new NDArray[]{this, other}, null);
    }

    public NDArray max() {
        return this.manager.invoke("_np_max", (NDArray)this, null);
    }

    public NDArray max(int[] axes) {
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axis", axes);
        return this.manager.invoke("_np_max", (NDArray)this, params);
    }

    public NDArray max(int[] axes, boolean keepDims) {
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axis", axes);
        params.addParam("keepdims", keepDims);
        return this.manager.invoke("_np_max", (NDArray)this, params);
    }

    public NDArray min() {
        return this.manager.invoke("_np_min", (NDArray)this, null);
    }

    public NDArray min(int[] axes, boolean keepDims) {
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axis", axes);
        params.addParam("keepdims", keepDims);
        return this.manager.invoke("_np_min", (NDArray)this, params);
    }

    /*
     * Exception decompiling
     */
    public NDArray sum() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray sum(int[] axes, boolean keepDims) {
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axis", axes);
        params.addParam("keepdims", keepDims);
        return this.manager.invoke("_np_sum", (NDArray)this, params);
    }

    public NDArray prod() {
        return this.manager.invoke("_np_prod", (NDArray)this, null);
    }

    public NDArray prod(int[] axes, boolean keepDims) {
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axis", axes);
        params.addParam("keepdims", keepDims);
        return this.manager.invoke("_np_prod", (NDArray)this, params);
    }

    public NDArray mean() {
        return this.manager.invoke("_npi_mean", (NDArray)this, null);
    }

    public NDArray mean(int[] axes, boolean keepDims) {
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axis", axes);
        params.addParam("keepdims", keepDims);
        return this.manager.invoke("_npi_mean", (NDArray)this, params);
    }

    public NDArray rotate90(int times, int[] axes) {
        if (axes.length != 2) {
            throw new IllegalArgumentException("Axes must be 2");
        }
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axes", axes);
        params.addParam("k", times);
        return this.manager.invoke("_npi_rot90", (NDArray)this, params);
    }

    public NDArray trace(int offset, int axis1, int axis2) {
        MxOpParams params = new MxOpParams();
        params.addParam("offset", offset);
        params.addParam("axis1", axis1);
        params.addParam("axis2", axis2);
        return this.manager.invoke("_np_trace", (NDArray)this, params);
    }

    public NDList split(long[] indices, int axis) {
        if (indices.length == 0) {
            return new NDList(new NDArray[]{this});
        }
        MxOpParams params = new MxOpParams();
        if (indices[0] != 0L) {
            long[] tempIndices = new long[indices.length + 1];
            tempIndices[0] = 0L;
            System.arraycopy(indices, 0, tempIndices, 1, indices.length);
            indices = tempIndices;
        }
        params.addTupleParam("indices", indices);
        params.addParam("axis", axis);
        params.addParam("squeeze_axis", false);
        return this.manager.invoke("_npi_split", new NDList(new NDArray[]{this}), params);
    }

    public NDArray flatten() {
        return this.reshape(new Shape(new long[]{Math.toIntExact(this.size())}));
    }

    public NDArray reshape(Shape shape) {
        MxOpParams params = new MxOpParams();
        params.addParam("newshape", shape);
        return this.manager.invoke("_np_reshape", (NDArray)this, params);
    }

    public NDArray expandDims(int axis) {
        MxOpParams params = new MxOpParams();
        params.addParam("axis", axis);
        return this.manager.invoke("_npi_expand_dims", (NDArray)this, params);
    }

    public NDArray squeeze() {
        return this.manager.invoke("_np_squeeze", (NDArray)this, null);
    }

    public NDArray squeeze(int[] axes) {
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axis", axes);
        return this.manager.invoke("_np_squeeze", (NDArray)this, params);
    }

    public NDArray logicalAnd(NDArray other) {
        MxNDArray thisArr = this.getDataType() == DataType.BOOLEAN ? this.toType(DataType.INT32, false) : this;
        other = other.getDataType() == DataType.BOOLEAN ? other.toType(DataType.INT32, false) : other;
        return this.manager.invoke("broadcast_logical_and", new NDArray[]{thisArr, other}, null).toType(DataType.BOOLEAN, false);
    }

    public NDArray logicalOr(NDArray other) {
        MxNDArray thisArr = this.getDataType() == DataType.BOOLEAN ? this.toType(DataType.INT32, false) : this;
        other = other.getDataType() == DataType.BOOLEAN ? other.toType(DataType.INT32, false) : other;
        return this.manager.invoke("broadcast_logical_or", new NDArray[]{thisArr, other}, null).toType(DataType.BOOLEAN, false);
    }

    public NDArray logicalXor(NDArray other) {
        MxNDArray thisArr = this.getDataType() == DataType.BOOLEAN ? this.toType(DataType.INT32, false) : this;
        other = other.getDataType() == DataType.BOOLEAN ? other.toType(DataType.INT32, false) : other;
        return this.manager.invoke("broadcast_logical_xor", new NDArray[]{thisArr, other}, null).toType(DataType.BOOLEAN, false);
    }

    public NDArray logicalNot() {
        return this.manager.invoke("_npi_logical_not", (NDArray)this, null);
    }

    public NDArray argSort(int axis, boolean ascending) {
        MxOpParams params = new MxOpParams();
        params.addParam("axis", axis);
        params.addParam("is_ascend", ascending);
        params.setDataType(DataType.INT64);
        return this.manager.invoke("_npi_argsort", (NDArray)this, params);
    }

    public NDArray sort(int axis) {
        MxOpParams params = new MxOpParams();
        params.addParam("axis", axis);
        return this.manager.invoke("_npi_sort", (NDArray)this, params);
    }

    public NDArray sort() {
        return this.manager.invoke("_npi_sort", (NDArray)this, null);
    }

    public NDArray softmax(int axis) {
        if (this.isEmpty()) {
            return this.manager.create(this.getShape());
        }
        MxOpParams params = new MxOpParams();
        params.addParam("axis", axis);
        return this.manager.invoke("_npx_softmax", (NDArray)this, params);
    }

    public NDArray logSoftmax(int axis) {
        if (this.isEmpty()) {
            return this.manager.create(this.getShape());
        }
        MxOpParams params = new MxOpParams();
        params.addParam("axis", axis);
        return this.manager.invoke("_npx_log_softmax", (NDArray)this, params);
    }

    public NDArray cumSum() {
        return this.manager.invoke("_np_cumsum", (NDArray)this, null);
    }

    public NDArray cumSum(int axis) {
        MxOpParams params = new MxOpParams();
        params.addParam("axis", axis);
        return this.manager.invoke("_np_cumsum", (NDArray)this, params);
    }

    public void intern(NDArray replaced) {
        MxNDArray arr = (MxNDArray)replaced;
        Pointer oldHandle = this.handle.getAndSet(arr.handle.getAndSet(null));
        JnaUtils.waitToRead(oldHandle);
        JnaUtils.freeNdArray(oldHandle);
        arr.close();
    }

    public NDArray isInfinite() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public NDArray isNaN() {
        return this.manager.invoke("_npi_isnan", (NDArray)this, null);
    }

    public NDArray toDense() {
        if (!this.isSparse()) {
            return this.duplicate();
        }
        return this.castStorage(SparseFormat.DENSE);
    }

    public NDArray tile(long repeats) {
        if (this.isEmpty()) {
            return this.duplicate();
        }
        int dim = this.isScalar() ? 1 : this.getShape().dimension();
        long[] repeatsArray = new long[dim];
        Arrays.fill(repeatsArray, repeats);
        return this.tile(repeatsArray);
    }

    public NDArray tile(int axis, long repeats) {
        if (this.isScalar()) {
            throw new IllegalArgumentException("scalar didn't support specifying axis");
        }
        long[] repeatsArray = new long[this.getShape().dimension()];
        Arrays.fill(repeatsArray, 1L);
        repeatsArray[this.withAxis((int)axis)] = repeats;
        return this.tile(repeatsArray);
    }

    public NDArray tile(long[] repeats) {
        MxOpParams params = new MxOpParams();
        params.addTupleParam("reps", repeats);
        return this.manager.invoke("_npi_tile", (NDArray)this, params);
    }

    public NDArray tile(Shape desiredShape) {
        return this.tile(this.repeatsToMatchShape(desiredShape));
    }

    public NDArray repeat(long repeats) {
        if (this.isEmpty()) {
            return this.duplicate();
        }
        int dim = this.isScalar() ? 1 : this.getShape().dimension();
        long[] repeatsArray = new long[dim];
        Arrays.fill(repeatsArray, repeats);
        return this.repeat(repeatsArray);
    }

    public NDArray repeat(int axis, long repeats) {
        long[] repeatsArray = new long[this.getShape().dimension()];
        Arrays.fill(repeatsArray, 1L);
        repeatsArray[this.withAxis((int)axis)] = repeats;
        return this.repeat(repeatsArray);
    }

    public NDArray repeat(long[] repeats) {
        MxNDArray array = this;
        int baseAxis = this.getShape().dimension() - repeats.length;
        for (int i = 0; i < repeats.length; ++i) {
            if (repeats[i] <= 1L) continue;
            MxNDArray previousArray = array;
            MxOpParams params = new MxOpParams();
            params.addParam("repeats", repeats[i]);
            params.addParam("axis", baseAxis + i);
            array = this.manager.invoke("_np_repeat", (NDArray)array, params);
            if (previousArray == this) continue;
            previousArray.close();
        }
        return array;
    }

    public NDArray repeat(Shape desiredShape) {
        return this.repeat(this.repeatsToMatchShape(desiredShape));
    }

    public NDArray dot(NDArray other) {
        return this.manager.invoke("_np_dot", new NDArray[]{this, other}, null);
    }

    public NDArray matMul(NDArray other) {
        if (this.isScalar() || other.isScalar()) {
            throw new IllegalArgumentException("scalar is not allowed for matMul()");
        }
        return this.manager.invoke("_npi_matmul", new NDArray[]{this, other}, null);
    }

    public NDArray clip(Number min, Number max) {
        MxOpParams params = new MxOpParams();
        params.addParam("a_min", min);
        params.addParam("a_max", max);
        return this.manager.invoke("_npi_clip", (NDArray)this, params);
    }

    public NDArray swapAxes(int axis1, int axis2) {
        MxOpParams params = new MxOpParams();
        params.addParam("dim1", axis1);
        params.addParam("dim2", axis2);
        return this.manager.invoke("_npi_swapaxes", (NDArray)this, params);
    }

    public NDArray flip(int ... axes) {
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axis", axes);
        return this.manager.invoke("_npi_flip", (NDArray)this, params);
    }

    public NDArray transpose() {
        return this.manager.invoke("_np_transpose", (NDArray)this, null);
    }

    public NDArray transpose(int ... dimensions) {
        if (Arrays.stream(dimensions).anyMatch(d -> d < 0)) {
            throw new UnsupportedOperationException("Passing -1 for broadcasting the dimension is not currently supported");
        }
        if (!Arrays.equals(Arrays.stream(dimensions).sorted().toArray(), IntStream.range(0, this.getShape().dimension()).toArray())) {
            throw new IllegalArgumentException("You must include each of the dimensions from 0 until " + this.getShape().dimension());
        }
        MxOpParams params = new MxOpParams();
        params.addTupleParam("axes", dimensions);
        return this.manager.invoke("_np_transpose", (NDArray)this, params);
    }

    public NDArray broadcast(Shape shape) {
        MxOpParams params = new MxOpParams();
        params.setShape(shape);
        return this.manager.invoke("_npi_broadcast_to", (NDArray)this, params);
    }

    public NDArray argMax() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("attempt to get argMax of an empty NDArray");
        }
        return this.manager.invoke("_npi_argmax", (NDArray)this, null);
    }

    public NDArray argMax(int axis) {
        MxOpParams params = new MxOpParams();
        params.addParam("axis", axis);
        return this.manager.invoke("_npi_argmax", (NDArray)this, params);
    }

    public NDArray argMin() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("attempt to get argMin of an empty NDArray");
        }
        return this.manager.invoke("_npi_argmin", (NDArray)this, null);
    }

    public NDArray argMin(int axis) {
        MxOpParams params = new MxOpParams();
        params.addParam("axis", axis);
        return this.manager.invoke("_npi_argmin", (NDArray)this, params);
    }

    public NDArray percentile(Number percentile) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public NDArray percentile(Number percentile, int[] dimension) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public NDArray median() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public NDArray median(int[] axes) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public NDArray nonzero() {
        MxNDArray thisArr = this.getDataType() == DataType.BOOLEAN ? this.toType(DataType.INT32, false) : this;
        return this.manager.invoke("_npx_nonzero", (NDArray)thisArr, null);
    }

    public NDArray erfinv() {
        return this.manager.invoke("erfinv", (NDArray)this, null);
    }

    public NDArray norm(boolean keepDims) {
        MxOpParams params = new MxOpParams();
        params.add("flag", -2);
        params.addParam("keepdims", keepDims);
        return this.manager.invoke("_npi_norm", (NDArray)this, params);
    }

    public NDArray norm(int ord, int[] axes, boolean keepDims) {
        MxOpParams params = new MxOpParams();
        params.addParam("ord", (double)ord);
        params.addTupleParam("axis", axes);
        params.addParam("keepdims", keepDims);
        return this.manager.invoke("_npi_norm", (NDArray)this, params);
    }

    public NDArray oneHot(int depth, float onValue, float offValue, DataType dataType) {
        MxOpParams params = new MxOpParams();
        params.add("depth", depth);
        params.add("on_value", Float.valueOf(onValue));
        params.add("off_value", Float.valueOf(offValue));
        params.add("dtype", dataType);
        return this.manager.invoke("_npx_one_hot", (NDArray)this, params).toType(dataType, false);
    }

    public NDArray batchDot(NDArray other) {
        return this.manager.invoke("_npx_batch_dot", new NDArray[]{this, other}, null);
    }

    public NDArrayEx getNDArrayInternal() {
        return this.mxNDArrayEx;
    }

    private long[] repeatsToMatchShape(Shape desiredShape) {
        Shape curShape = this.getShape();
        int dimension = curShape.dimension();
        if (desiredShape.dimension() > dimension) {
            throw new IllegalArgumentException("The desired shape has too many dimensions");
        }
        if (desiredShape.dimension() < dimension) {
            int additionalDimensions = dimension - desiredShape.dimension();
            desiredShape = curShape.slice(0, additionalDimensions).addAll(desiredShape);
        }
        long[] repeats = new long[dimension];
        for (int i = 0; i < dimension; ++i) {
            if (curShape.get(i) == 0L || desiredShape.get(i) % curShape.get(i) != 0L) {
                throw new IllegalArgumentException("The desired shape is not a multiple of the original shape");
            }
            repeats[i] = Math.round(Math.ceil((double)desiredShape.get(i) / (double)curShape.get(i)));
        }
        return repeats;
    }

    private int withAxis(int axis) {
        return Math.floorMod(axis, this.getShape().dimension());
    }

    public void waitToRead() {
        JnaUtils.waitToRead((Pointer)this.getHandle());
    }

    public void waitToWrite() {
        JnaUtils.waitToWrite((Pointer)this.getHandle());
    }

    public void waitAll() {
        JnaUtils.waitToRead((Pointer)this.getHandle());
    }

    public boolean equals(Object obj) {
        if (obj instanceof MxNDArray) {
            return this.contentEquals((NDArray)((MxNDArray)((Object)obj)));
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        if (this.isReleased()) {
            return "This array is already closed";
        }
        return this.toDebugString();
    }

    public void close() {
        Pointer pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            JnaUtils.waitToRead(pointer);
            JnaUtils.freeNdArray(pointer);
        }
        this.manager.detachInternal(this.getUid());
    }
}

