/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.Model;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.ZeroShotImageClassificationTranslator;
import ai.djl.modality.Classifications;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.VisionLanguageInput;
import ai.djl.modality.cv.translator.ZeroShotImageClassificationServingTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ZeroShotImageClassificationTranslatorFactory
implements TranslatorFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Set<Pair<Type, Type>> SUPPORTED_TYPES = new HashSet<Pair<Type, Type>>();

    public Set<Pair<Type, Type>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) throws TranslateException {
        Path modelPath = model.getModelPath();
        try {
            HuggingFaceTokenizer tokenizer = HuggingFaceTokenizer.builder(arguments).optTokenizerPath(modelPath).optManager(model.getNDManager()).build();
            ZeroShotImageClassificationTranslator translator = ZeroShotImageClassificationTranslator.builder(tokenizer, arguments).build();
            if (input == VisionLanguageInput.class && output == Classifications.class) {
                return translator;
            }
            if (input == Input.class && output == Output.class) {
                return new ZeroShotImageClassificationServingTranslator((Translator)translator);
            }
            throw new IllegalArgumentException("Unsupported input/output types.");
        }
        catch (IOException e) {
            throw new TranslateException("Failed to load tokenizer.", (Throwable)e);
        }
    }

    static {
        SUPPORTED_TYPES.add((Pair<Type, Type>)new Pair(VisionLanguageInput.class, Classifications.class));
        SUPPORTED_TYPES.add((Pair<Type, Type>)new Pair(Input.class, Output.class));
    }
}

